/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.CommandInterface;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CommandInterpreter
extends Thread {
    private Map<String, CommandInterface> commandList;
    private int totalCommands;
    private BufferedReader in;
    private PrintWriter out;
    private String prompt;
    private boolean done;
    private boolean trace;
    private final CommandHistory history = new CommandHistory();
    private Socket socket;
    private static final Pattern historyPush = Pattern.compile("(.+):p");
    private static final Pattern editPattern = Pattern.compile("\\^(.+?)\\^(.*?)\\^?");
    private static final Pattern bbPattern = Pattern.compile("(!!)");

    public CommandInterpreter(BufferedReader bufferedReader, PrintWriter printWriter) {
        this.init(bufferedReader, printWriter);
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public CommandInterpreter() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        PrintWriter printWriter = new PrintWriter(System.out);
        this.init(bufferedReader, printWriter);
    }

    private void init(BufferedReader bufferedReader, PrintWriter printWriter) {
        this.commandList = new HashMap<String, CommandInterface>();
        this.addStandardCommands();
        this.setStreams(bufferedReader, printWriter);
    }

    public void setStreams(BufferedReader bufferedReader, PrintWriter printWriter) {
        this.in = bufferedReader;
        this.out = printWriter;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    private void addStandardCommands() {
        this.add("help", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                CommandInterpreter.this.dumpCommands();
                return "";
            }

            @Override
            public String getHelp() {
                return "lists available commands";
            }
        });
        this.add("history", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                CommandInterpreter.this.history.dump();
                return "";
            }

            @Override
            public String getHelp() {
                return "shows command history";
            }
        });
        this.add("status", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                CommandInterpreter.this.putResponse("Total number of commands: " + CommandInterpreter.this.totalCommands);
                return "";
            }

            @Override
            public String getHelp() {
                return "shows command status";
            }
        });
        this.add("echo", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                StringBuilder stringBuilder = new StringBuilder(80);
                for (int i = 1; i < stringArray.length; ++i) {
                    stringBuilder.append(stringArray[i]);
                    stringBuilder.append(' ');
                }
                CommandInterpreter.this.putResponse(stringBuilder.toString());
                return "";
            }

            @Override
            public String getHelp() {
                return "display a line of text";
            }
        });
        this.add("quit", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                CommandInterpreter.this.done = true;
                return "";
            }

            @Override
            public String getHelp() {
                return "exit the shell";
            }
        });
        this.add("on_exit", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                return "";
            }

            @Override
            public String getHelp() {
                return "command executed upon exit";
            }
        });
        this.add("version", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                CommandInterpreter.this.putResponse("Command Interpreter - Version 1.1 ");
                return "";
            }

            @Override
            public String getHelp() {
                return "displays version information";
            }
        });
        this.add("gc", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                Runtime.getRuntime().gc();
                return "";
            }

            @Override
            public String getHelp() {
                return "performs garbage collection";
            }
        });
        this.add("memory", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                long l = Runtime.getRuntime().totalMemory();
                long l2 = Runtime.getRuntime().freeMemory();
                CommandInterpreter.this.putResponse("Free Memory  : " + (double)l2 / 1048576.0 + " mbytes");
                CommandInterpreter.this.putResponse("Total Memory : " + (double)l / 1048576.0 + " mbytes");
                return "";
            }

            @Override
            public String getHelp() {
                return "shows memory statistics";
            }
        });
        this.add("delay", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                if (stringArray.length == 2) {
                    try {
                        float f = Float.parseFloat(stringArray[1]);
                        Thread.sleep((long)(f * 1000.0f));
                    }
                    catch (NumberFormatException numberFormatException) {
                        CommandInterpreter.this.putResponse("Usage: delay time-in-seconds");
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    CommandInterpreter.this.putResponse("Usage: delay time-in-seconds");
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "pauses for a given number of seconds";
            }
        });
        this.add("repeat", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                if (stringArray.length >= 3) {
                    try {
                        int n = Integer.parseInt(stringArray[1]);
                        String[] stringArray2 = Arrays.copyOfRange(stringArray, 2, stringArray.length);
                        for (int i = 0; i < n; ++i) {
                            CommandInterpreter.this.putResponse(CommandInterpreter.this.execute(stringArray2));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        CommandInterpreter.this.putResponse("Usage: repeat count command args");
                    }
                } else {
                    CommandInterpreter.this.putResponse("Usage: repeat count command args");
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "repeatedly execute a command";
            }
        });
        this.add("load", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                if (stringArray.length == 2) {
                    if (!CommandInterpreter.this.load(stringArray[1])) {
                        CommandInterpreter.this.putResponse("load: trouble loading " + stringArray[1]);
                    }
                } else {
                    CommandInterpreter.this.putResponse("Usage: load filename");
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "load and execute commands from a file";
            }
        });
        this.add("chain", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                if (stringArray.length > 1) {
                    String[] stringArray2 = new String[stringArray.length - 1];
                    ArrayList<String[]> arrayList = new ArrayList<String[]>(5);
                    int n = 0;
                    for (int i = 1; i < stringArray.length; ++i) {
                        if (stringArray[i].equals(";")) {
                            if (n <= 0) continue;
                            arrayList.add(Arrays.copyOf(stringArray2, n));
                            n = 0;
                            continue;
                        }
                        stringArray2[n++] = stringArray[i];
                    }
                    if (n > 0) {
                        arrayList.add(Arrays.copyOf(stringArray2, n));
                    }
                    for (String[] stringArray3 : arrayList) {
                        CommandInterpreter.this.putResponse(CommandInterpreter.this.execute(stringArray3));
                    }
                } else {
                    CommandInterpreter.this.putResponse("Usage: chain cmd1 ; cmd2 ; cmd3 ");
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "execute multiple commands on a single line";
            }
        });
        this.add("time", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                if (stringArray.length > 1) {
                    String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
                    long l = System.currentTimeMillis();
                    CommandInterpreter.this.putResponse(CommandInterpreter.this.execute(stringArray2));
                    long l2 = System.currentTimeMillis();
                    CommandInterpreter.this.putResponse("Time: " + (double)(l2 - l) / 1000.0 + " seconds");
                } else {
                    CommandInterpreter.this.putResponse("Usage: time cmd [args]");
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "report the time it takes to run a command";
            }
        });
    }

    private void dumpCommands() {
        for (Map.Entry<String, CommandInterface> entry : new TreeMap<String, CommandInterface>(this.commandList).entrySet()) {
            this.putResponse(entry.getKey() + " - " + entry.getValue().getHelp());
        }
    }

    public void add(String string, CommandInterface commandInterface) {
        this.commandList.put(string, commandInterface);
    }

    public void addAlias(String string, String string2) {
        this.commandList.put(string2, this.commandList.get(string));
    }

    public void add(Map<String, CommandInterface> map) {
        this.commandList.putAll(map);
    }

    public synchronized void putResponse(String string) {
        if (string != null && !string.isEmpty()) {
            this.out.println(string);
            this.out.flush();
            if (this.trace) {
                System.out.println("Out: " + string);
            }
        }
    }

    protected void onExit() {
        this.execute("on_exit");
        System.out.println("----------\n");
    }

    protected String execute(String[] stringArray) {
        String string = "";
        if (stringArray.length > 0) {
            CommandInterface commandInterface = this.commandList.get(stringArray[0]);
            string = commandInterface != null ? commandInterface.execute(this, stringArray) : "ERR  CMD_NOT_FOUND";
            ++this.totalCommands;
        }
        return string;
    }

    public String execute(String string) {
        if (this.trace) {
            System.out.println("Execute: " + string);
        }
        return this.execute(this.parseMessage(string));
    }

    protected String[] parseMessage(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(20);
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(33, 255);
        streamTokenizer.quoteChar(34);
        streamTokenizer.quoteChar(34);
        streamTokenizer.commentChar(35);
        try {
            while (true) {
                int n;
                if ((n = streamTokenizer.nextToken()) == -3) {
                    arrayList.add(streamTokenizer.sval);
                    continue;
                }
                if (n == 39 || n == 34) {
                    arrayList.add(streamTokenizer.sval);
                    continue;
                }
                if (n == -2) {
                    System.out.println("Unexpected numeric token!");
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public void run() {
        while (!this.done) {
            try {
                this.printPrompt();
                String string = this.getInputLine();
                if (string == null) break;
                if (this.trace) {
                    System.out.println("\n----------");
                    System.out.println("In : " + string);
                }
                if ((string = string.trim()).isEmpty()) continue;
                this.putResponse(this.execute(string));
            }
            catch (IOException iOException) {
                System.out.println("Exception: CommandInterpreter.run()");
                break;
            }
        }
        this.onExit();
    }

    private String getInputLine() throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string;
        block19: {
            string = this.in.readLine();
            if (string == null) {
                return null;
            }
            bl3 = false;
            bl2 = false;
            bl = false;
            Matcher matcher = historyPush.matcher(string);
            if (matcher.matches()) {
                bl3 = true;
                bl2 = true;
                string = matcher.group(1);
            }
            if (string.startsWith("^")) {
                matcher = editPattern.matcher(string);
                if (matcher.matches()) {
                    String string2 = matcher.group(1);
                    String string3 = matcher.group(2);
                    try {
                        Pattern pattern = Pattern.compile(string2);
                        Matcher matcher2 = pattern.matcher(this.history.getLast(0));
                        if (matcher2.find()) {
                            string = matcher2.replaceFirst(string3);
                            bl2 = true;
                            break block19;
                        }
                        bl = true;
                        this.putResponse(string + ": substitution failed");
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        bl = true;
                        this.putResponse("Bad regexp: " + patternSyntaxException.getDescription());
                    }
                } else {
                    bl = true;
                    this.putResponse("bad substitution sytax, use ^old^new^");
                }
            } else {
                matcher = bbPattern.matcher(string);
                if (matcher.find()) {
                    string = matcher.replaceAll(this.history.getLast(0));
                    bl2 = true;
                } else if (string.startsWith("!")) {
                    if (string.matches("!\\d+")) {
                        int n = Integer.parseInt(string.substring(1));
                        string = this.history.get(n);
                    } else if (string.matches("!-\\d+")) {
                        int n = Integer.parseInt(string.substring(2));
                        string = this.history.getLast(n - 1);
                    } else {
                        string = this.history.findLast(string.substring(1));
                    }
                    bl2 = true;
                }
            }
        }
        if (bl) {
            return "";
        }
        if (!string.isEmpty()) {
            this.history.add(string);
        }
        if (bl2) {
            this.putResponse(string);
        }
        return bl3 ? "" : string;
    }

    public void close() {
        this.done = true;
    }

    private void printPrompt() {
        if (this.prompt != null) {
            this.out.print(this.prompt);
            this.out.flush();
        }
    }

    public boolean load(String string) {
        try {
            String string2;
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3 = this.execute(string2);
                if (string3.equals("OK")) continue;
                this.putResponse(string3);
            }
            fileReader.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setPrompt(String string) {
        this.prompt = string;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public PrintWriter getPrintWriter() {
        return this.out;
    }

    public static void main(String[] stringArray) {
        CommandInterpreter commandInterpreter = new CommandInterpreter();
        try {
            System.out.println("Welcome to the Command interpreter test program");
            commandInterpreter.setPrompt("CI> ");
            commandInterpreter.run();
            System.out.println("Goodbye!");
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
        }
    }

    class CommandHistory {
        private final List<String> history = new ArrayList<String>(100);

        CommandHistory() {
        }

        public void add(String string) {
            this.history.add(string);
        }

        public String getLast(int n) {
            if (this.history.size() > n) {
                return this.history.get(this.history.size() - 1 - n);
            }
            CommandInterpreter.this.putResponse("command not found");
            return "";
        }

        public String get(int n) {
            if (this.history.size() > n) {
                return this.history.get(n);
            }
            CommandInterpreter.this.putResponse("command not found");
            return "";
        }

        public String findLast(String string) {
            for (int i = this.history.size() - 1; i >= 0; --i) {
                String string2 = this.get(i);
                if (!string2.startsWith(string)) continue;
                return string2;
            }
            CommandInterpreter.this.putResponse("command not found");
            return "";
        }

        public void dump() {
            for (int i = 0; i < this.history.size(); ++i) {
                String string = this.get(i);
                CommandInterpreter.this.putResponse(i + " " + string);
            }
        }
    }
}

