/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

public class Complex {
    private double real;
    private double imaginary;

    public Complex() {
        this.reset();
    }

    public Complex(double d) {
        this.set(d, 0.0);
    }

    public Complex(double d, double d2) {
        this.set(d, d2);
    }

    public double getReal() {
        return this.real;
    }

    public double getImaginary() {
        return this.imaginary;
    }

    public void reset() {
        this.real = 0.0;
        this.imaginary = 0.0;
    }

    public void set(double d, double d2) {
        this.real = d;
        this.imaginary = d2;
    }

    public void addComplex(Complex complex, Complex complex2) {
        this.real = complex.real + complex2.real;
        this.imaginary = complex.imaginary + complex2.imaginary;
    }

    public void subtractComplex(Complex complex, Complex complex2) {
        this.real = complex.real - complex2.real;
        this.imaginary = complex.imaginary - complex2.imaginary;
    }

    public void multiplyComplex(Complex complex, Complex complex2) {
        this.real = complex.real * complex2.real - complex.imaginary * complex2.imaginary;
        this.imaginary = complex.real * complex2.imaginary + complex.imaginary * complex2.real;
    }

    public void divideComplex(Complex complex, Complex complex2) {
        this.real = complex.real * complex2.real + complex.imaginary * complex2.imaginary;
        this.imaginary = complex.imaginary * complex2.real - complex.real * complex2.imaginary;
        this.scaleComplex(this, complex2.squaredMagnitudeComplex());
    }

    public void scaleComplex(Complex complex, double d) {
        this.real = complex.real / d;
        this.imaginary = complex.imaginary / d;
    }

    public double squaredMagnitudeComplex() {
        double d = this.real * this.real + this.imaginary * this.imaginary;
        return d;
    }

    public String toString() {
        return "(" + this.real + ", " + this.imaginary + ')';
    }
}

