/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class CustomThreadFactory
implements ThreadFactory {
    static final AtomicInteger poolNumber = new AtomicInteger(1);
    final ThreadGroup group;
    final AtomicInteger threadNumber = new AtomicInteger(1);
    final String namePrefix;
    final boolean daemon;
    final int priority;

    public CustomThreadFactory(String string, boolean bl, int n) {
        if (n > 10 || n < 1) {
            throw new IllegalArgumentException("illegal thread priority");
        }
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = string + "-" + poolNumber.getAndIncrement() + "-thread-";
        this.daemon = bl;
        this.priority = n;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (thread.isDaemon() != this.daemon) {
            thread.setDaemon(this.daemon);
        }
        if (thread.getPriority() != this.priority) {
            thread.setPriority(this.priority);
        }
        return thread;
    }
}

