/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;

public class ExtendedStreamTokenizer {
    private String path;
    private final StreamTokenizer st;
    private final Reader reader;
    private boolean atEOF;
    private final List<String> putbackList;

    public ExtendedStreamTokenizer(String string) throws FileNotFoundException {
        this(string, false);
    }

    public ExtendedStreamTokenizer(String string, boolean bl) throws FileNotFoundException {
        this(new FileReader(string), bl);
        this.path = string;
    }

    public ExtendedStreamTokenizer(InputStream inputStream, int n, boolean bl) {
        this(new InputStreamReader(inputStream), bl);
        this.commentChar(n);
    }

    public ExtendedStreamTokenizer(InputStream inputStream, boolean bl) {
        this(new InputStreamReader(inputStream), bl);
    }

    public ExtendedStreamTokenizer(Reader reader, boolean bl) {
        this.reader = new BufferedReader(reader);
        this.st = new StreamTokenizer(reader);
        this.st.resetSyntax();
        this.st.whitespaceChars(0, 32);
        this.st.wordChars(33, 255);
        this.st.eolIsSignificant(bl);
        this.putbackList = new ArrayList<String>();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public void whitespaceChars(int n, int n2) {
        this.st.whitespaceChars(n, n2);
    }

    public void commentChar(int n) {
        this.st.commentChar(n);
    }

    public String getString() throws IOException {
        if (!this.putbackList.isEmpty()) {
            return this.putbackList.remove(this.putbackList.size() - 1);
        }
        this.st.nextToken();
        if (this.st.ttype == -1) {
            this.atEOF = true;
        }
        if (this.st.ttype != -3 && this.st.ttype != 10 && this.st.ttype != -1) {
            this.corrupt("word expected but not found");
        }
        if (this.st.ttype == 10 || this.st.ttype == -1) {
            return null;
        }
        return this.st.sval;
    }

    public void unget(String string) {
        this.putbackList.add(string);
    }

    public boolean isEOF() {
        return this.atEOF;
    }

    private void corrupt(String string) throws StreamCorruptedException {
        throw new StreamCorruptedException(string + " at line " + this.st.lineno() + " in file " + this.path);
    }

    public int getLineNumber() {
        return this.st.lineno();
    }

    public void expectString(String string) throws IOException {
        String string2 = this.getString();
        if (!string2.equals(string)) {
            this.corrupt("error matching expected string '" + string + "' in line: '" + string2 + '\'');
        }
    }

    public void expectInt(String string, int n) throws IOException {
        int n2 = this.getInt(string);
        if (n2 != n) {
            this.corrupt("Expecting integer " + n);
        }
    }

    public int getInt(String string) throws IOException {
        int n = 0;
        try {
            String string2 = this.getString();
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.corrupt("while parsing int " + string);
        }
        return n;
    }

    public double getDouble(String string) throws IOException {
        double d = 0.0;
        try {
            String string2 = this.getString();
            d = string2.equals("inf") ? Double.POSITIVE_INFINITY : Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.corrupt("while parsing double " + string);
        }
        return d;
    }

    public float getFloat(String string) throws IOException {
        float f = 0.0f;
        try {
            String string2 = this.getString();
            f = string2.equals("inf") ? Float.POSITIVE_INFINITY : Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.corrupt("while parsing float " + string);
        }
        return f;
    }

    public float getFloat(String string, float f) throws IOException {
        float f2 = 0.0f;
        try {
            String string2 = this.getString();
            f2 = string2 == null ? f : (string2.equals("inf") ? Float.POSITIVE_INFINITY : Float.parseFloat(string2));
        }
        catch (NumberFormatException numberFormatException) {
            this.corrupt("while parsing float " + string);
        }
        return f2;
    }

    public void skipwhite() throws IOException {
        String string = null;
        while (!this.isEOF()) {
            string = this.getString();
            if (string == null) continue;
            this.unget(string);
            break;
        }
    }
}

