/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.HypothesisFile;
import edu.cmu.sphinx.util.HypothesisWord;
import edu.cmu.sphinx.util.ReferenceFile;
import edu.cmu.sphinx.util.ReferenceUtterance;
import java.io.IOException;

public class GapInsertionDetector {
    private ReferenceFile referenceFile;
    private HypothesisFile hypothesisFile;
    private boolean showGapInsertions;

    public GapInsertionDetector(String string, String string2, boolean bl) throws IOException {
        this.referenceFile = new ReferenceFile(string);
        this.hypothesisFile = new HypothesisFile(string2);
    }

    public int detect() throws IOException {
        int n = 0;
        boolean bl = false;
        ReferenceUtterance referenceUtterance = this.referenceFile.nextUtterance();
        StringBuilder stringBuilder = new StringBuilder();
        while (!bl) {
            HypothesisWord hypothesisWord = this.hypothesisFile.nextWord();
            if (hypothesisWord != null) {
                boolean bl2 = false;
                while (referenceUtterance != null && referenceUtterance.getEndTime() < hypothesisWord.getStartTime()) {
                    referenceUtterance = this.referenceFile.nextUtterance();
                }
                if (referenceUtterance != null) {
                    if (referenceUtterance.isSilenceGap()) {
                        bl2 = true;
                    } else {
                        while (referenceUtterance.getEndTime() < hypothesisWord.getEndTime()) {
                            referenceUtterance = this.referenceFile.nextUtterance();
                            if (referenceUtterance != null && !referenceUtterance.isSilenceGap()) continue;
                            bl2 = true;
                            break;
                        }
                    }
                } else {
                    bl2 = true;
                }
                if (!bl2) continue;
                ++n;
                if (!this.showGapInsertions) continue;
                stringBuilder.append("GapInsError: Utterance: ").append(this.hypothesisFile.getUtteranceCount()).append(" Word: ").append(hypothesisWord.getText()).append(" (").append(hypothesisWord.getStartTime()).append(',').append(hypothesisWord.getEndTime()).append("). ");
                if (referenceUtterance != null) {
                    assert (referenceUtterance.isSilenceGap());
                    stringBuilder.append("Reference: <sil> (").append(referenceUtterance.getStartTime()).append(',').append(referenceUtterance.getEndTime()).append(')');
                }
                stringBuilder.append('\n');
                continue;
            }
            bl = true;
        }
        if (this.showGapInsertions) {
            System.out.println(stringBuilder);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: java GapInsertionDetector <referenceFile> <hypothesisFile>");
        }
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            GapInsertionDetector gapInsertionDetector = new GapInsertionDetector(string, string2, true);
            System.out.println("# of gap insertions: " + gapInsertionDetector.detect());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

