/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.HypothesisUtterance;
import edu.cmu.sphinx.util.HypothesisWord;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;

class HypothesisFile {
    private BufferedReader reader;
    private Iterator<HypothesisWord> iterator;
    private int utteranceCount;

    HypothesisFile(String string) throws IOException {
        this.reader = new BufferedReader(new FileReader(string));
    }

    HypothesisWord nextWord() throws IOException {
        if (this.iterator == null || !this.iterator.hasNext()) {
            HypothesisUtterance hypothesisUtterance = this.nextUtterance();
            this.iterator = hypothesisUtterance != null ? hypothesisUtterance.getWords().iterator() : null;
        }
        if (this.iterator == null) {
            return null;
        }
        return this.iterator.next();
    }

    private HypothesisUtterance nextUtterance() throws IOException {
        String string = this.reader.readLine();
        if (string != null) {
            ++this.utteranceCount;
            HypothesisUtterance hypothesisUtterance = new HypothesisUtterance(string);
            if (hypothesisUtterance.getWordCount() <= 0) {
                return this.nextUtterance();
            }
            return hypothesisUtterance;
        }
        return null;
    }

    public int getUtteranceCount() {
        return this.utteranceCount;
    }
}

