/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

public final class LogMath {
    public static final float LOG_ZERO = -3.4028235E38f;
    public static final float LOG_ONE = 0.0f;
    private static LogMath instance;
    private static float logBase;
    private static boolean useTable;
    private float naturalLogBase = (float)Math.log(logBase);
    private float inverseNaturalLogBase = 1.0f / this.naturalLogBase;
    private float[] theAddTable;

    private LogMath() {
        if (useTable) {
            int n = (int)(-Math.rint(this.linearToLog(this.logToLinear(0.5f) - 1.0)));
            if (n > 150000) {
                n = 150000;
            }
            if (n <= 0) {
                throw new IllegalArgumentException("The log base " + logBase + " yields a very small addTable. " + "Either choose not to use the addTable, " + "or choose a logBase closer to 1.0");
            }
            this.theAddTable = new float[n];
            for (int i = 0; i < n; ++i) {
                float f = (float)this.logToLinear(-i);
                this.theAddTable[i] = this.linearToLog(f += 1.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogMath getLogMath() {
        if (null != instance) return instance;
        Class<LogMath> clazz = LogMath.class;
        synchronized (LogMath.class) {
            if (null != instance) return instance;
            instance = new LogMath();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogBase(float f) {
        Class<LogMath> clazz = LogMath.class;
        synchronized (LogMath.class) {
            assert (instance == null);
            logBase = f;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUseTable(boolean bl) {
        Class<LogMath> clazz = LogMath.class;
        synchronized (LogMath.class) {
            assert (instance == null);
            useTable = bl;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final float addAsLinear(float f, float f2) {
        float f3 = f;
        float f4 = f - f2;
        if (f4 < 0.0f) {
            f3 = f2;
            f4 = -f4;
        }
        return f3 + this.addTable(f4);
    }

    private float addTableActualComputation(float f) {
        double d = this.logToLinear(-f);
        return this.linearToLog(d += 1.0);
    }

    private float addTable(float f) throws IllegalArgumentException {
        int n = (int)((double)f + 0.5);
        if (n < this.theAddTable.length) {
            return this.theAddTable[n];
        }
        return 0.0f;
    }

    public final float subtractAsLinear(float f, float f2) throws IllegalArgumentException {
        if (f < f2) {
            throw new IllegalArgumentException("Subtraction results in log of a negative number: " + f + " - " + f2);
        }
        double d = 1.0;
        return f + this.linearToLog(d -= this.logToLinear(f2 - f));
    }

    public static float logToLog(float f, float f2, float f3) throws IllegalArgumentException {
        float f4 = (float)Math.log(f2);
        float f5 = (float)Math.log(f3);
        return f * f4 / f5;
    }

    public final float lnToLog(float f) {
        return f * this.inverseNaturalLogBase;
    }

    public final float log10ToLog(float f) {
        return LogMath.logToLog(f, 10.0f, logBase);
    }

    public final float logToLn(float f) {
        return f * this.naturalLogBase;
    }

    public final float linearToLog(double d) throws IllegalArgumentException {
        return (float)Math.log(d) * this.inverseNaturalLogBase;
    }

    public final double logToLinear(float f) {
        return Math.exp(this.logToLn(f));
    }

    public final float getLogBase() {
        return logBase;
    }

    public boolean isUseTable() {
        return useTable;
    }

    public static float log10(float f) {
        return (float)(0.4342944819 * Math.log(f));
    }

    public void linearToLog(float[] fArray) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.linearToLog(fArray[i]);
        }
    }

    public void logToLinear(float[] fArray, float[] fArray2) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = (float)this.logToLinear(fArray[i]);
        }
    }

    static {
        logBase = 1.0001f;
        useTable = true;
    }
}

