/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class NISTAlign {
    static final int OK = 0;
    static final int SUBSTITUTION = 1;
    static final int INSERTION = 2;
    static final int DELETION = 3;
    static final int MAX_PENALTY = 1000000;
    static final int SUBSTITUTION_PENALTY = 100;
    static final int INSERTION_PENALTY = 75;
    static final int DELETION_PENALTY = 75;
    static final String STARS = "********************************************";
    static final String SPACES = "                                            ";
    static final String HRULE = "============================================================================";
    private int totalSentences;
    private int totalSentencesWithErrors;
    private int totalSentencesWithSubtitutions;
    private int totalSentencesWithInsertions;
    private int totalSentencesWithDeletions;
    private int totalReferenceWords;
    private int totalHypothesisWords;
    private int totalAlignedWords;
    private int totalWordsCorrect;
    private int totalSubstitutions;
    private int totalInsertions;
    private int totalDeletions;
    private int substitutions;
    private int insertions;
    private int deletions;
    private int correct;
    private String rawReference;
    private String referenceAnnotation;
    private LinkedList<Object> referenceItems;
    private LinkedList<String> alignedReferenceWords;
    private String rawHypothesis;
    private LinkedList<Object> hypothesisItems;
    private LinkedList<String> alignedHypothesisWords;
    static final DecimalFormat percentageFormat = new DecimalFormat("##0.0%");
    private boolean showResults;
    private boolean showAlignedResults;

    public NISTAlign(boolean bl, boolean bl2) {
        this.showResults = bl;
        this.showAlignedResults = bl2;
        this.resetTotals();
    }

    public void setShowResults(boolean bl) {
        this.showResults = bl;
    }

    public void setShowAlignedResults(boolean bl) {
        this.showAlignedResults = bl;
    }

    public void resetTotals() {
        this.totalSentences = 0;
        this.totalSentencesWithErrors = 0;
        this.totalSentencesWithSubtitutions = 0;
        this.totalSentencesWithInsertions = 0;
        this.totalSentencesWithDeletions = 0;
        this.totalReferenceWords = 0;
        this.totalHypothesisWords = 0;
        this.totalAlignedWords = 0;
        this.totalWordsCorrect = 0;
        this.totalSubstitutions = 0;
        this.totalInsertions = 0;
        this.totalDeletions = 0;
    }

    public boolean align(String string, String string2) {
        this.rawReference = string;
        this.rawHypothesis = string2;
        int n = this.rawReference.indexOf(40);
        if (n != -1) {
            this.referenceAnnotation = this.rawReference.substring(n);
            this.referenceItems = this.toList(this.rawReference.substring(0, n));
        } else {
            this.referenceAnnotation = null;
            this.referenceItems = this.toList(this.rawReference);
        }
        n = this.rawHypothesis.indexOf(40);
        this.hypothesisItems = n != -1 ? this.toList(this.rawHypothesis.substring(0, n)) : this.toList(this.rawHypothesis);
        this.substitutions = 0;
        this.insertions = 0;
        this.deletions = 0;
        this.alignWords(this.backtrace(this.createBacktraceTable(this.referenceItems, this.hypothesisItems, new Comparator(){

            @Override
            public boolean isSimilar(Object object, Object object2) {
                if (object instanceof String && object2 instanceof String) {
                    return ((String)object).equals(object2);
                }
                return false;
            }
        })), new StringRenderer(){

            @Override
            public String getRef(Object object, Object object2) {
                return (String)object;
            }

            @Override
            public String getHyp(Object object, Object object2) {
                return (String)object2;
            }
        });
        this.correct = this.alignedReferenceWords.size() - (this.insertions + this.deletions + this.substitutions);
        this.updateTotals();
        return this.insertions + this.deletions + this.substitutions == 0;
    }

    public String getReference() {
        return this.toString(this.referenceItems);
    }

    public String getHypothesis() {
        return this.toString(this.hypothesisItems);
    }

    public String getAlignedReference() {
        return this.toString(this.alignedReferenceWords);
    }

    public String getAlignedHypothesis() {
        return this.toString(this.alignedHypothesisWords);
    }

    public int getTotalWordErrors() {
        return this.totalSubstitutions + this.totalInsertions + this.totalDeletions;
    }

    public float getTotalWordAccuracy() {
        if (this.totalReferenceWords == 0) {
            return 0.0f;
        }
        return (float)this.totalWordsCorrect / (float)this.totalReferenceWords;
    }

    public float getTotalWordErrorRate() {
        if (this.totalReferenceWords == 0) {
            return 0.0f;
        }
        return (float)this.getTotalWordErrors() / (float)this.totalReferenceWords;
    }

    public float getTotalSentenceAccuracy() {
        int n = this.totalSentences - this.totalSentencesWithErrors;
        if (this.totalSentences == 0) {
            return 0.0f;
        }
        return (float)n / (float)this.totalSentences;
    }

    public int getTotalWords() {
        return this.totalReferenceWords;
    }

    public int getTotalSubstitutions() {
        return this.totalSubstitutions;
    }

    public int getTotalInsertions() {
        return this.totalInsertions;
    }

    public int getTotalDeletions() {
        return this.totalDeletions;
    }

    public int getTotalSentences() {
        return this.totalSentences;
    }

    public int getTotalSentencesWithErrors() {
        return this.totalSentencesWithDeletions;
    }

    public void printSentenceSummary() {
        if (this.showResults) {
            System.out.println("REF:       " + this.toString(this.referenceItems));
            System.out.println("HYP:       " + this.toString(this.hypothesisItems));
        }
        if (this.showAlignedResults) {
            System.out.println("ALIGN_REF: " + this.toString(this.alignedReferenceWords));
            System.out.println("ALIGN_HYP: " + this.toString(this.alignedHypothesisWords));
        }
    }

    public void printTotalSummary() {
        if (this.totalSentences > 0) {
            System.out.print("   Accuracy: " + this.toPercentage("##0.000%", this.getTotalWordAccuracy()));
            System.out.println("    Errors: " + this.getTotalWordErrors() + "  (Sub: " + this.totalSubstitutions + "  Ins: " + this.totalInsertions + "  Del: " + this.totalDeletions + ')');
            System.out.println("   Words: " + this.totalReferenceWords + "   Matches: " + this.totalWordsCorrect + "    WER: " + this.toPercentage("##0.000%", this.getTotalWordErrorRate()));
            System.out.println("   Sentences: " + this.totalSentences + "   Matches: " + (this.totalSentences - this.totalSentencesWithErrors) + "   SentenceAcc: " + this.toPercentage("##0.000%", this.getTotalSentenceAccuracy()));
        }
    }

    public void printNISTSentenceSummary() {
        int n = this.substitutions + this.insertions + this.deletions;
        System.out.println();
        System.out.print("REF: " + this.toString(this.alignedReferenceWords));
        if (this.referenceAnnotation != null) {
            System.out.print(' ' + this.referenceAnnotation);
        }
        System.out.println();
        System.out.print("HYP: " + this.toString(this.alignedHypothesisWords));
        if (this.referenceAnnotation != null) {
            System.out.print(' ' + this.referenceAnnotation);
        }
        System.out.println();
        System.out.println();
        if (this.referenceAnnotation != null) {
            System.out.println("SENTENCE " + this.totalSentences + "  " + this.referenceAnnotation);
        } else {
            System.out.println("SENTENCE " + this.totalSentences);
        }
        System.out.println("Correct          = " + this.toPercentage("##0.0%", this.correct, this.referenceItems.size()) + this.padLeft(5, this.correct) + "   (" + this.padLeft(6, this.totalWordsCorrect) + ')');
        System.out.println("Errors           = " + this.toPercentage("##0.0%", n, this.referenceItems.size()) + this.padLeft(5, n) + "   (" + this.padLeft(6, this.totalSentencesWithErrors) + ')');
        System.out.println();
        System.out.println(HRULE);
    }

    public void printNISTTotalSummary() {
        int n = this.totalSentences - this.totalSentencesWithErrors;
        System.out.println();
        System.out.println("---------- SUMMARY ----------");
        System.out.println();
        System.out.println("SENTENCE RECOGNITION PERFORMANCE:");
        System.out.println("sentences                          " + this.totalSentences);
        System.out.println("  correct                  " + this.toPercentage("##0.0%", n, this.totalSentences) + " (" + this.padLeft(4, n) + ')');
        System.out.println("  with error(s)            " + this.toPercentage("##0.0%", this.totalSentencesWithErrors, this.totalSentences) + " (" + this.padLeft(4, this.totalSentencesWithErrors) + ')');
        System.out.println("    with substitutions(s)  " + this.toPercentage("##0.0%", this.totalSentencesWithSubtitutions, this.totalSentences) + " (" + this.padLeft(4, this.totalSentencesWithSubtitutions) + ')');
        System.out.println("    with insertion(s)      " + this.toPercentage("##0.0%", this.totalSentencesWithInsertions, this.totalSentences) + " (" + this.padLeft(4, this.totalSentencesWithInsertions) + ')');
        System.out.println("    with deletions(s)      " + this.toPercentage("##0.0%", this.totalSentencesWithDeletions, this.totalSentences) + " (" + this.padLeft(4, this.totalSentencesWithDeletions) + ')');
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("WORD RECOGNITION PERFORMANCE:");
        System.out.println("Correct           = " + this.toPercentage("##0.0%", this.totalWordsCorrect, this.totalReferenceWords) + " (" + this.padLeft(6, this.totalWordsCorrect) + ')');
        System.out.println("Substitutions     = " + this.toPercentage("##0.0%", this.totalSubstitutions, this.totalReferenceWords) + " (" + this.padLeft(6, this.totalSubstitutions) + ')');
        System.out.println("Deletions         = " + this.toPercentage("##0.0%", this.totalDeletions, this.totalReferenceWords) + " (" + this.padLeft(6, this.totalDeletions) + ')');
        System.out.println("Insertions        = " + this.toPercentage("##0.0%", this.totalInsertions, this.totalReferenceWords) + " (" + this.padLeft(6, this.totalInsertions) + ')');
        System.out.println("Errors            = " + this.toPercentage("##0.0%", this.getTotalWordErrors(), this.totalReferenceWords) + " (" + this.padLeft(6, this.getTotalWordErrors()) + ')');
        System.out.println();
        System.out.println("Ref. words           = " + this.padLeft(6, this.totalReferenceWords));
        System.out.println("Hyp. words           = " + this.padLeft(6, this.totalHypothesisWords));
        System.out.println("Aligned words        = " + this.padLeft(6, this.totalAlignedWords));
        System.out.println();
        System.out.println("WORD ACCURACY=  " + this.toPercentage("##0.000%", this.totalWordsCorrect, this.totalReferenceWords) + " (" + this.padLeft(5, this.totalWordsCorrect) + '/' + this.padLeft(5, this.totalReferenceWords) + ")  ERRORS= " + this.toPercentage("##0.000%", this.getTotalWordErrors(), this.totalReferenceWords) + " (" + this.padLeft(5, this.getTotalWordErrors()) + '/' + this.padLeft(5, this.totalReferenceWords) + ')');
        System.out.println();
    }

    int[][] createBacktraceTable(LinkedList<?> linkedList, LinkedList<?> linkedList2, Comparator comparator) {
        int n;
        int[][] nArray = new int[linkedList.size() + 1][linkedList2.size() + 1];
        int[][] nArray2 = new int[linkedList.size() + 1][linkedList2.size() + 1];
        nArray[0][0] = 0;
        nArray2[0][0] = 0;
        for (n = 1; n <= linkedList.size(); ++n) {
            nArray[n][0] = 75 * n;
            nArray2[n][0] = 3;
        }
        for (n = 1; n <= linkedList2.size(); ++n) {
            nArray[0][n] = 75 * n;
            nArray2[0][n] = 2;
        }
        for (n = 1; n <= linkedList.size(); ++n) {
            for (int i = 1; i <= linkedList2.size(); ++i) {
                int n2 = nArray[n - 1][i] + 75;
                int n3 = 1000000;
                if (n2 < n3) {
                    n3 = n2;
                    nArray[n][i] = n2;
                    nArray2[n][i] = 3;
                }
                if (comparator.isSimilar(linkedList.get(n - 1), linkedList2.get(i - 1))) {
                    n2 = nArray[n - 1][i - 1];
                    if (n2 < n3) {
                        n3 = n2;
                        nArray[n][i] = n2;
                        nArray2[n][i] = 0;
                    }
                } else {
                    n2 = nArray[n - 1][i - 1] + 100;
                    if (n2 < n3) {
                        n3 = n2;
                        nArray[n][i] = n2;
                        nArray2[n][i] = 1;
                    }
                }
                if ((n2 = nArray[n][i - 1] + 75) >= n3) continue;
                n3 = n2;
                nArray[n][i] = n2;
                nArray2[n][i] = 2;
            }
        }
        return nArray2;
    }

    LinkedList<Integer> backtrace(int[][] nArray) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n = this.referenceItems.size();
        int n2 = this.hypothesisItems.size();
        while (n >= 0 && n2 >= 0) {
            linkedList.add(nArray[n][n2]);
            switch (nArray[n][n2]) {
                case 0: {
                    --n;
                    --n2;
                    break;
                }
                case 1: {
                    --n;
                    --n2;
                    ++this.substitutions;
                    break;
                }
                case 2: {
                    --n2;
                    ++this.insertions;
                    break;
                }
                case 3: {
                    --n;
                    ++this.deletions;
                }
            }
        }
        return linkedList;
    }

    void alignWords(LinkedList<Integer> linkedList, StringRenderer stringRenderer) {
        ListIterator listIterator = this.referenceItems.listIterator();
        ListIterator listIterator2 = this.hypothesisItems.listIterator();
        Object var7_5 = null;
        Object var8_6 = null;
        this.alignedReferenceWords = new LinkedList();
        this.alignedHypothesisWords = new LinkedList();
        for (int i = linkedList.size() - 2; i >= 0; --i) {
            String string;
            String string2;
            int n = linkedList.get(i);
            if (n != 2) {
                var7_5 = listIterator.next();
                string2 = stringRenderer.getRef(var7_5, var8_6);
            } else {
                string2 = null;
            }
            if (n != 3) {
                var8_6 = listIterator2.next();
                string = stringRenderer.getHyp(var7_5, var8_6);
            } else {
                string = null;
            }
            switch (n) {
                case 1: {
                    string2 = string2.toUpperCase();
                    string = string.toUpperCase();
                    break;
                }
                case 2: {
                    string = string.toUpperCase();
                    break;
                }
                case 3: {
                    string2 = string2.toUpperCase();
                    break;
                }
            }
            if (string2 == null) {
                string2 = STARS.substring(0, string.length());
            }
            if (string == null) {
                string = STARS.substring(0, string2.length());
            }
            if (string2.length() > string.length()) {
                string = string.concat(SPACES.substring(0, string2.length() - string.length()));
            } else if (string2.length() < string.length()) {
                string2 = string2.concat(SPACES.substring(0, string.length() - string2.length()));
            }
            this.alignedReferenceWords.add(string2);
            this.alignedHypothesisWords.add(string);
        }
    }

    void updateTotals() {
        ++this.totalSentences;
        if (this.substitutions + this.insertions + this.deletions != 0) {
            ++this.totalSentencesWithErrors;
        }
        if (this.substitutions != 0) {
            ++this.totalSentencesWithSubtitutions;
        }
        if (this.insertions != 0) {
            ++this.totalSentencesWithInsertions;
        }
        if (this.deletions != 0) {
            ++this.totalSentencesWithDeletions;
        }
        this.totalReferenceWords += this.referenceItems.size();
        this.totalHypothesisWords += this.hypothesisItems.size();
        this.totalAlignedWords += this.alignedReferenceWords.size();
        this.totalWordsCorrect += this.correct;
        this.totalSubstitutions += this.substitutions;
        this.totalInsertions += this.insertions;
        this.totalDeletions += this.deletions;
    }

    String toPercentage(String string, int n, int n2) {
        percentageFormat.applyPattern(string);
        return this.padLeft(6, percentageFormat.format((double)n / (double)n2));
    }

    String toPercentage(String string, float f) {
        percentageFormat.applyPattern(string);
        return percentageFormat.format(f);
    }

    String padLeft(int n, int n2) {
        return this.padLeft(n, Integer.toString(n2));
    }

    String padLeft(int n, String string) {
        int n2 = string.length();
        if (n2 < n) {
            return SPACES.substring(0, n - n2).concat(string);
        }
        return string;
    }

    LinkedList<Object> toList(String string) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            linkedList.add(string2);
        }
        return linkedList;
    }

    private String toString(LinkedList<? extends Object> linkedList) {
        if (linkedList == null || linkedList.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            stringBuilder.append(listIterator.next()).append(' ');
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        NISTAlign nISTAlign = new NISTAlign(true, true);
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(stringArray[0])));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(new FileInputStream(stringArray[1])));
            try {
                while (true) {
                    String string = bufferedReader.readLine();
                    String string2 = bufferedReader2.readLine();
                    if (string != null && string2 != null) {
                        nISTAlign.align(string, string2);
                        nISTAlign.printNISTSentenceSummary();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            nISTAlign.printNISTTotalSummary();
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
            System.out.println();
            System.out.println("Usage: align <reference file> <hypothesis file>");
            System.out.println();
        }
    }

    public static interface StringRenderer {
        public String getRef(Object var1, Object var2);

        public String getHyp(Object var1, Object var2);
    }

    static interface Comparator {
        public boolean isSimilar(Object var1, Object var2);
    }
}

