/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.BatchFile;
import edu.cmu.sphinx.util.BatchItem;
import edu.cmu.sphinx.util.BatchManager;
import edu.cmu.sphinx.util.TestFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.nio.channels.FileLock;
import java.util.List;

public class PooledBatchManager
implements BatchManager {
    private final String batchFile;
    private final int skip;
    private File processingFile;
    private static final File topDir = new File("tests");
    private static final File inputDir = new File(topDir, "ToRun");
    private static final File inProcessDir = new File(topDir, "InProcess");
    private static final File completedDir = new File(topDir, "Completed");
    private static final File resultsDir = new File(topDir, "Results");
    private static final File lockFile = new File(".lock");
    private FileLock lock;
    private PrintStream oldOut;
    private final FileFilter testFileFilter = new TestFileFilter();

    public PooledBatchManager(String string, int n) {
        this.batchFile = string;
        this.skip = n;
    }

    @Override
    public void start() throws IOException {
        this.lock();
        try {
            this.createDirectories();
            this.redirectStdout();
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public BatchItem getNextItem() throws IOException {
        this.lock();
        try {
            File file;
            if (this.processingFile != null) {
                file = this.getCompletedFile(this.processingFile);
                this.processingFile.renameTo(file);
                this.processingFile = null;
            }
            if ((file = this.getNextFile()) != null) {
                this.processingFile = this.getProcessingFile(file);
                file.renameTo(this.processingFile);
                System.out.println("Processing: " + this.processingFile);
                BatchItem batchItem = this.getBatchItem(this.processingFile);
                return batchItem;
            }
            BatchItem batchItem = null;
            return batchItem;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void stop() throws IOException {
        this.lock();
        try {
            this.closeStdout();
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public String getFilename() {
        return this.batchFile;
    }

    private void createDirectories() throws IOException {
        if (!topDir.isDirectory()) {
            topDir.mkdir();
            inProcessDir.mkdir();
            completedDir.mkdir();
            resultsDir.mkdir();
            this.createInputDirectory();
        }
    }

    private void createInputDirectory() throws IOException {
        inputDir.mkdir();
        List<String> list = BatchFile.getLines(this.batchFile, this.skip);
        for (int i = 0; i < list.size(); ++i) {
            String string = Integer.toString(i + 1);
            String string2 = list.get(i);
            this.createInputFile(inputDir, string, string2);
        }
    }

    private void createInputFile(File file, String string, String string2) throws IOException {
        File file2 = new File(file, string);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        PrintStream printStream = new PrintStream(fileOutputStream);
        printStream.println(string2);
        printStream.close();
    }

    private void redirectStdout() throws IOException {
        String string = this.getMyName();
        File file = File.createTempFile(string, ".out", resultsDir);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PrintStream printStream = new PrintStream(fileOutputStream);
        this.oldOut = System.out;
        System.setOut(printStream);
        System.out.println("# These results collected on " + this.getMyName());
    }

    private String getMyName() throws IOException {
        return InetAddress.getLocalHost().getHostName();
    }

    private void closeStdout() throws IOException {
        System.out.close();
        System.setOut(this.oldOut);
    }

    private void lock() throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(lockFile, "rw");
        this.lock = randomAccessFile.getChannel().lock();
        randomAccessFile.close();
    }

    private void unlock() throws IOException {
        this.lock.release();
        this.lock = null;
    }

    private File getCompletedFile(File file) {
        return new File(completedDir, file.getName());
    }

    private File getProcessingFile(File file) {
        return new File(inProcessDir, file.getName());
    }

    private File getNextFile() throws IOException {
        File[] fileArray = inputDir.listFiles(this.testFileFilter);
        if (fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }

    private BatchItem getBatchItem(File file) throws IOException {
        List<String> list = BatchFile.getLines(file.getPath());
        if (list.size() != 1) {
            throw new IOException("Bad batch file size");
        }
        String string = list.get(0);
        return new BatchItem(BatchFile.getFilename(string), BatchFile.getReference(string));
    }
}

