/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.BatchFile;
import edu.cmu.sphinx.util.BatchItem;
import edu.cmu.sphinx.util.BatchManager;
import java.io.IOException;
import java.util.List;

public class SimpleBatchManager
implements BatchManager {
    private final String batchFile;
    private final int skip;
    private int whichBatch;
    private final int totalBatches;
    private int curItem;
    private List<String> items;

    public SimpleBatchManager(String string, int n, int n2, int n3) {
        this.batchFile = string;
        this.skip = n;
        this.whichBatch = n2;
        this.totalBatches = n3;
    }

    @Override
    public void start() throws IOException {
        this.curItem = 0;
        this.items = this.getBatchItems(this.batchFile);
    }

    @Override
    public BatchItem getNextItem() throws IOException {
        if (this.curItem >= this.items.size()) {
            return null;
        }
        String string = this.items.get(this.curItem++);
        return new BatchItem(BatchFile.getFilename(string), BatchFile.getReference(string));
    }

    @Override
    public void stop() throws IOException {
    }

    @Override
    public String getFilename() {
        return this.batchFile;
    }

    private List<String> getBatchItems(String string) throws IOException {
        List<String> list = BatchFile.getLines(string, this.skip);
        if (this.totalBatches > 1) {
            int n = list.size() / this.totalBatches;
            if (n < 1) {
                n = 1;
            }
            if (this.whichBatch >= this.totalBatches) {
                this.whichBatch = this.totalBatches - 1;
            }
            int n2 = this.whichBatch * n;
            list = this.whichBatch == this.totalBatches - 1 ? list.subList(n2, list.size()) : list.subList(n2, n2 + n);
        }
        return list;
    }
}

