/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.CommandInterface;
import edu.cmu.sphinx.util.CommandInterpreter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;

public class SocketCommandClient {
    private String host;
    private int port;
    private Socket socket;
    private BufferedReader inReader;
    private PrintWriter outWriter;

    public SocketCommandClient(String string, int n) throws IOException {
        this.host = string;
        this.port = n;
        this.open();
    }

    public SocketCommandClient() {
    }

    public synchronized void open(String string, int n) throws IOException {
        this.host = string;
        this.port = n;
        this.socket = new Socket(this.host, this.port);
        this.inReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.outWriter = new PrintWriter(this.socket.getOutputStream(), true);
    }

    private synchronized void open() throws IOException {
        this.open(this.host, this.port);
    }

    public int getSoTimeout() throws SocketException {
        if (this.socket != null) {
            return this.socket.getSoTimeout();
        }
        return 0;
    }

    public void setSoTimeout(int n) throws SocketException {
        if (this.socket != null) {
            this.socket.setSoTimeout(n);
        } else {
            System.err.println("SocketCommandClient.setSoTimeout(): socket is null");
        }
    }

    public synchronized boolean sendCommand(String string) {
        for (int i = 0; i < 2; ++i) {
            if (!this.checkOpen()) continue;
            this.outWriter.println(string);
            if (this.outWriter.checkError()) {
                this.close();
                System.err.println("IO error while sending " + string);
                continue;
            }
            return true;
        }
        return false;
    }

    public synchronized String getResponse() {
        String string = null;
        if (!this.checkOpen()) {
            return null;
        }
        try {
            string = this.inReader.readLine();
        }
        catch (IOException iOException) {
            System.err.println("IO error while reading response");
            this.close();
        }
        return string;
    }

    public synchronized boolean isResponse() {
        boolean bl = false;
        if (!this.checkOpen()) {
            return false;
        }
        try {
            bl = this.inReader.ready();
        }
        catch (IOException iOException) {
            System.err.println("IO error while checking response");
            this.close();
        }
        return bl;
    }

    public synchronized String sendCommandGetResponse(String string) {
        String string2 = null;
        if (this.sendCommand(string)) {
            string2 = this.getResponse();
        }
        return string2;
    }

    public synchronized void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            } else {
                System.err.println("SocketCommandClient.close(): socket is null");
            }
        }
        catch (IOException iOException) {
            System.err.println("Trouble closing socket");
        }
        this.socket = null;
    }

    private synchronized boolean checkOpen() {
        try {
            if (this.socket == null) {
                this.open();
            }
        }
        catch (IOException iOException) {
            System.err.println("SocketCommandClient.checkOpen():could not open socket");
            this.socket = null;
        }
        return this.socket != null;
    }

    public static void main(String[] stringArray) {
        try {
            CommandInterpreter commandInterpreter = new CommandInterpreter();
            final SocketCommandClient socketCommandClient = new SocketCommandClient("localhost", 7890);
            commandInterpreter.add("s", new CommandInterface(){

                @Override
                public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 1; i < stringArray.length; ++i) {
                        stringBuilder.append(stringArray[i]).append(' ');
                    }
                    socketCommandClient.sendCommand(stringBuilder.toString());
                    return "";
                }

                @Override
                public String getHelp() {
                    return "send a command";
                }
            });
            commandInterpreter.add("r", new CommandInterface(){

                @Override
                public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                    while (socketCommandClient.isResponse()) {
                        commandInterpreter.putResponse(socketCommandClient.getResponse());
                    }
                    return "";
                }

                @Override
                public String getHelp() {
                    return "receive a response";
                }
            });
            commandInterpreter.add("sr", new CommandInterface(){

                @Override
                public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 1; i < stringArray.length; ++i) {
                        stringBuilder.append(stringArray[i]).append(' ');
                    }
                    commandInterpreter.putResponse(socketCommandClient.sendCommandGetResponse(stringBuilder.toString()));
                    while (socketCommandClient.isResponse()) {
                        commandInterpreter.putResponse(socketCommandClient.getResponse());
                    }
                    return "";
                }

                @Override
                public String getHelp() {
                    return "send a command, receive a response";
                }
            });
            commandInterpreter.setPrompt("scc-test> ");
            commandInterpreter.run();
        }
        catch (Exception exception) {
            System.err.println("error occured.");
            exception.printStackTrace();
            System.exit(-1);
        }
    }
}

