/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.CommandInterface;
import edu.cmu.sphinx.util.CommandInterpreter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SocketCommandInterpreter
extends Thread {
    private final int port;
    private final Map<String, CommandInterface> commandList;
    private boolean trace;
    private boolean acceptConnections = true;

    public SocketCommandInterpreter(int n) {
        this.port = n;
        this.commandList = new HashMap<String, CommandInterface>();
    }

    public void add(String string, CommandInterface commandInterface) {
        this.commandList.put(string, commandInterface);
    }

    @Override
    public final void run() {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(this.port);
            System.out.println("Waiting on " + serverSocket);
        }
        catch (IOException iOException) {
            System.out.println("Can't open socket on port " + this.port);
            iOException.printStackTrace();
            return;
        }
        while (this.acceptConnections) {
            try {
                Socket socket = serverSocket.accept();
                this.spawnCommandInterpreter(socket);
            }
            catch (IOException iOException) {
                System.err.println("Could not accept socket " + iOException);
                iOException.printStackTrace();
                break;
            }
        }
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            System.err.println("Could not close server socket " + iOException);
            iOException.printStackTrace();
        }
    }

    public void setStopAcceptConnections() {
        this.acceptConnections = false;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    private void spawnCommandInterpreter(Socket socket) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            CommandInterpreter commandInterpreter = new CommandInterpreter(bufferedReader, printWriter);
            commandInterpreter.setSocket(socket);
            commandInterpreter.add(this.commandList);
            commandInterpreter.setTrace(this.trace);
            commandInterpreter.start();
        }
        catch (IOException iOException) {
            System.err.println("Could not attach CI to socket " + iOException);
        }
    }

    public static void main(String[] stringArray) {
        SocketCommandInterpreter socketCommandInterpreter = new SocketCommandInterpreter(7890);
        socketCommandInterpreter.add("testCommand", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                return "this is a test";
            }

            @Override
            public String getHelp() {
                return "a test command";
            }
        });
        socketCommandInterpreter.add("time", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter commandInterpreter, String[] stringArray) {
                return "Time is " + new Date();
            }

            @Override
            public String getHelp() {
                return "shows the current time";
            }
        });
        System.out.println("Welcome to SocketCommand interpreter test program");
        socketCommandInterpreter.setTrace(true);
        socketCommandInterpreter.start();
    }
}

