/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.Utilities;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SphinxLogFormatter
extends Formatter {
    private final DateFormat DATE_FORMATTER = new SimpleDateFormat("HH:mm:ss.SSS");
    private boolean terse;

    public void setTerse(boolean bl) {
        this.terse = bl;
    }

    public boolean getTerse() {
        return this.terse;
    }

    @Override
    public String format(LogRecord logRecord) {
        String string;
        if (this.terse) {
            return logRecord.getMessage() + '\n';
        }
        String string2 = this.DATE_FORMATTER.format(new Date(logRecord.getMillis()));
        StringBuilder stringBuilder = new StringBuilder().append(string2).append(' ');
        String string3 = logRecord.getLoggerName();
        if (string3 != null) {
            String[] stringArray = string3.split("[.]");
            string = stringArray[stringArray.length - 1];
        } else {
            string = string3;
        }
        stringBuilder.append(Utilities.pad(logRecord.getLevel().getName() + ' ' + string, 24));
        stringBuilder.append("  ").append(logRecord.getMessage()).append('\n');
        return stringBuilder.toString();
    }
}

