/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import java.util.HashMap;
import java.util.Map;

public class StatisticsVariable {
    private static final Map<String, StatisticsVariable> pool = new HashMap<String, StatisticsVariable>();
    public double value;
    private final String name;
    private boolean enabled;

    public static StatisticsVariable getStatisticsVariable(String string) {
        StatisticsVariable statisticsVariable = pool.get(string);
        if (statisticsVariable == null) {
            statisticsVariable = new StatisticsVariable(string);
            pool.put(string, statisticsVariable);
        }
        return statisticsVariable;
    }

    public static StatisticsVariable getStatisticsVariable(String string, String string2) {
        return StatisticsVariable.getStatisticsVariable(string + '.' + string2);
    }

    public static void dumpAll() {
        System.out.println(" ========= statistics  =======");
        for (StatisticsVariable statisticsVariable : pool.values()) {
            statisticsVariable.dump();
        }
    }

    public static void resetAll() {
        for (StatisticsVariable statisticsVariable : pool.values()) {
            statisticsVariable.reset();
        }
    }

    private StatisticsVariable(String string) {
        this.name = string;
        this.value = 0.0;
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public void reset() {
        this.setValue(0.0);
    }

    public void dump() {
        if (this.isEnabled()) {
            System.out.println(this.name + ' ' + this.value);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public static void main(String[] stringArray) {
        StatisticsVariable statisticsVariable = StatisticsVariable.getStatisticsVariable("main", "loops");
        StatisticsVariable statisticsVariable2 = StatisticsVariable.getStatisticsVariable("main", "sum");
        StatisticsVariable statisticsVariable3 = StatisticsVariable.getStatisticsVariable("body", "foot");
        StatisticsVariable statisticsVariable4 = StatisticsVariable.getStatisticsVariable("body", "leg");
        StatisticsVariable statisticsVariable5 = StatisticsVariable.getStatisticsVariable("body", "finger");
        statisticsVariable3.setValue(2.0);
        statisticsVariable4.setValue(2.0);
        statisticsVariable5.setValue(10.0);
        StatisticsVariable.dumpAll();
        StatisticsVariable.dumpAll();
        for (int i = 0; i < 1000; ++i) {
            statisticsVariable.value += 1.0;
            statisticsVariable2.value += (double)i;
        }
        StatisticsVariable.dumpAll();
        StatisticsVariable statisticsVariable6 = StatisticsVariable.getStatisticsVariable("main", "loops");
        StatisticsVariable statisticsVariable7 = StatisticsVariable.getStatisticsVariable("main", "sum");
        for (int i = 0; i < 1000; ++i) {
            statisticsVariable6.value += 1.0;
            statisticsVariable7.value += (double)i;
        }
        StatisticsVariable.dumpAll();
        StatisticsVariable.resetAll();
        StatisticsVariable.dumpAll();
    }
}

