/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class StreamFactory {
    public static final String ZIP_FILE = "ZIP_FILE";
    public static final String DIRECTORY = "DIRECTORY";

    public static InputStream getInputStream(String string, String string2) throws IOException {
        if (string != null) {
            return StreamFactory.getInputStream(StreamFactory.resolve(string), string, string2);
        }
        return StreamFactory.getInputStream(DIRECTORY, string, string2);
    }

    public static InputStream getInputStream(String string, String string2, String string3) throws IOException {
        Object object;
        Object object2;
        URI uRI;
        String string4;
        InputStream inputStream = null;
        if (string2 == null) {
            string4 = null;
        } else {
            uRI = URI.create(string2);
            object2 = uRI.getScheme();
            object = uRI.getSchemeSpecificPart();
            File file = new File((String)object);
            URI uRI2 = file.getAbsoluteFile().toURI();
            string4 = object2 == null ? uRI2.getSchemeSpecificPart() : (String)object2 + ':' + uRI2.getSchemeSpecificPart();
        }
        if (string.equals(ZIP_FILE)) {
            try {
                uRI = new URI(string4);
                object2 = new ZipFile(new File(uRI));
                object = ((ZipFile)object2).getEntry(string3);
                if (object != null) {
                    inputStream = ((ZipFile)object2).getInputStream((ZipEntry)object);
                }
                ((ZipFile)object2).close();
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
                throw new ZipException("URISyntaxException: " + uRISyntaxException.getMessage());
            }
        } else if (string.equals(DIRECTORY)) {
            inputStream = string4 != null ? new FileInputStream(string4 + File.separator + string3) : new FileInputStream(string3);
        }
        return inputStream;
    }

    public static OutputStream getOutputStream(String string, String string2, boolean bl) throws IOException {
        if (string != null) {
            return StreamFactory.getOutputStream(StreamFactory.resolve(string), string, string2, bl);
        }
        return StreamFactory.getOutputStream(DIRECTORY, string, string2);
    }

    public static OutputStream getOutputStream(String string, String string2, String string3, boolean bl) throws IOException {
        OutputStream outputStream = null;
        if (string.equals(ZIP_FILE)) {
            try {
                System.out.println("WARNING: ZIP not yet fully supported.!");
                File file = new File(string2);
                File file2 = new File(file.getParent());
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(new File(new URI(string2)), bl);
                outputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
                ZipEntry zipEntry = new ZipEntry(string3);
                ((ZipOutputStream)outputStream).putNextEntry(zipEntry);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
                throw new ZipException("URISyntaxException: " + uRISyntaxException.getMessage());
            }
        } else if (string.equals(DIRECTORY)) {
            if (string2 != null) {
                File file = new File(string2 + File.separator + string3);
                File file3 = new File(file.getParent());
                if (!file3.exists()) {
                    file3.mkdirs();
                }
                outputStream = new FileOutputStream(string2 + File.separator + string3);
            } else {
                File file = new File(string3);
                File file4 = new File(file.getParent());
                if (!file4.exists()) {
                    file4.mkdirs();
                }
                outputStream = new FileOutputStream(string3);
            }
        } else {
            throw new IOException("Format not supported for writing");
        }
        return outputStream;
    }

    public static OutputStream getOutputStream(String string, String string2) throws IOException {
        if (string != null) {
            return StreamFactory.getOutputStream(StreamFactory.resolve(string), string, string2);
        }
        return StreamFactory.getOutputStream(DIRECTORY, string, string2);
    }

    public static OutputStream getOutputStream(String string, String string2, String string3) throws IOException {
        if (string.equals(ZIP_FILE)) {
            System.out.println("WARNING: overwriting ZIP or JAR file!");
            return StreamFactory.getOutputStream(StreamFactory.resolve(string2), string2, string3, false);
        }
        if (string.equals(DIRECTORY)) {
            return StreamFactory.getOutputStream(DIRECTORY, string2, string3, false);
        }
        throw new IOException("Format not supported for writing");
    }

    public static String resolve(String string) {
        if (string.endsWith(".jar") || string.endsWith(".zip")) {
            return ZIP_FILE;
        }
        return DIRECTORY;
    }
}

