/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.Utilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public class TimerPool {
    private static final Map<Object, List<Timer>> weakRefTimerPool = new WeakHashMap<Object, List<Timer>>();

    private TimerPool() {
    }

    public static synchronized Timer getTimer(Object object, String string) {
        if (!weakRefTimerPool.containsKey(object)) {
            weakRefTimerPool.put(object, new ArrayList());
        }
        List<Timer> list = weakRefTimerPool.get(object);
        for (Timer timer : list) {
            if (!timer.getName().equals(string)) continue;
            return timer;
        }
        Timer timer = new Timer(string);
        list.add(timer);
        return timer;
    }

    public static int getNumCachedTimers() {
        int n = 0;
        for (List<Timer> list : weakRefTimerPool.values()) {
            n += list.size();
        }
        return n;
    }

    public static void dumpAll(Logger logger) {
        TimerPool.showTimesShortTitle(logger);
        for (List<Timer> list : weakRefTimerPool.values()) {
            for (Timer timer : list) {
                timer.dump(logger);
            }
        }
    }

    private static void showTimesShortTitle(Logger logger) {
        String string = "Timers";
        String string2 = "# ----------------------------- " + string + "----------------------------------------------------------- ";
        logger.info(Utilities.pad(string2, 78));
        logger.info(Utilities.pad("# Name", 20) + ' ' + Utilities.pad("Count", 8) + Utilities.pad("CurTime", 10) + Utilities.pad("MinTime", 10) + Utilities.pad("MaxTime", 10) + Utilities.pad("AvgTime", 10) + Utilities.pad("TotTime", 10));
    }

    public static void resetAll() {
        for (List<Timer> list : weakRefTimerPool.values()) {
            for (Timer timer : list) {
                timer.reset();
            }
        }
    }
}

