/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class Utilities {
    private static final boolean TRACKING_OBJECTS = false;
    static long maxUsed;

    private Utilities() {
    }

    public static String pad(int n) {
        if (n > 0) {
            StringBuilder stringBuilder = new StringBuilder(n);
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public static String pad(String string, int n) {
        String string2 = string;
        int n2 = n - string.length();
        if (n2 > 0) {
            string2 = string + Utilities.pad(n - string.length());
        } else if (n2 < 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String pad(int n, int n2) {
        return Utilities.pad(String.valueOf(n), n2);
    }

    public static String pad(double d, int n) {
        return Utilities.pad(String.valueOf(d), n);
    }

    public static void dump(PrintWriter printWriter, int n, String string) {
        printWriter.print(Utilities.pad(n));
        printWriter.println(string);
    }

    public static void objectTracker(String string, int n) {
    }

    public static void dumpMemoryInfo(String string) {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        runtime.gc();
        long l2 = (runtime.freeMemory() - l) / 0x100000L;
        long l3 = runtime.freeMemory() / 0x100000L;
        long l4 = runtime.totalMemory() / 0x100000L;
        long l5 = runtime.totalMemory() - runtime.freeMemory();
        if (l5 > maxUsed) {
            maxUsed = l5;
        }
        System.out.println("Memory (mb)  total: " + l4 + " reclaimed: " + l2 + " free: " + l3 + " Max Used: " + maxUsed / 0x100000L + " -- " + string);
    }

    public static String doubleToScientificString(double d, int n) {
        DecimalFormat decimalFormat = new DecimalFormat();
        StringBuilder stringBuilder = new StringBuilder(5 + n).append("0.");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append("E00");
        decimalFormat.applyPattern(stringBuilder.toString());
        String string = decimalFormat.format(d);
        int n2 = string.indexOf(69);
        if (string.charAt(n2 + 1) != '-') {
            return string.substring(0, n2 + 1) + '+' + string.substring(n2 + 1);
        }
        return string;
    }

    public static boolean isCepstraFileBigEndian(String string) throws IOException {
        File file = new File(string);
        int n = (int)file.length();
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
        int n2 = dataInputStream.readInt() * 4 + 4;
        dataInputStream.close();
        return n == n2;
    }

    public static float readLittleEndianFloat(DataInputStream dataInputStream) throws IOException {
        return Float.intBitsToFloat(Utilities.readLittleEndianInt(dataInputStream));
    }

    public static int readLittleEndianInt(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readUnsignedByte() | dataInputStream.readUnsignedByte() << 8 | dataInputStream.readUnsignedByte() << 16 | dataInputStream.readUnsignedByte() << 24;
    }

    public static int swapInteger(int n) {
        return (0xFF & n) << 24 | (0xFF00 & n) << 8 | (0xFF0000 & n) >> 8 | (0xFF000000 & n) >> 24;
    }

    public static float swapFloat(float f) {
        return Float.intBitsToFloat(Utilities.swapInteger(Float.floatToRawIntBits(f)));
    }

    public static void floorData(float[] fArray, float f) {
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] < f)) continue;
            fArray[i] = f;
        }
    }

    public static void nonZeroFloor(float[] fArray, float f) {
        for (int i = 0; i < fArray.length; ++i) {
            if ((double)fArray[i] == 0.0 || !(fArray[i] < f)) continue;
            fArray[i] = f;
        }
    }

    public static void normalize(float[] fArray) {
        float f = 0.0f;
        for (float f2 : fArray) {
            f += f2;
        }
        if (f != 0.0f) {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = fArray[i] / f;
            }
        }
    }

    public static String join(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append(' ');
        }
        return stringBuilder.toString().trim();
    }

    public static List<Integer> asList(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int n : nArray) {
            arrayList.add(n);
        }
        return arrayList;
    }

    public static String pathJoin(String string, String string2) {
        if (string.length() > 0 && string.charAt(string.length() - 1) == '/') {
            string = string.substring(0, string.length() - 1);
        }
        if (string2.length() > 0 && string2.charAt(0) == '/') {
            string2 = string2.substring(1);
        }
        return string + "/" + string2;
    }
}

