/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props;

import edu.cmu.sphinx.util.props.RawPropertyData;
import edu.cmu.sphinx.util.props.SaxLoader;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigHandler
extends DefaultHandler {
    protected RawPropertyData rpd;
    protected Locator locator;
    protected List<String> itemList;
    protected String itemListName;
    protected StringBuilder curItem;
    protected final Map<String, RawPropertyData> rpdMap;
    protected final Map<String, String> globalProperties;
    private boolean replaceDuplicates;
    private final URL baseURL;

    public ConfigHandler(Map<String, RawPropertyData> map, Map<String, String> map2, boolean bl, URL uRL) {
        this.rpdMap = map;
        this.globalProperties = map2;
        this.replaceDuplicates = bl;
        this.baseURL = uRL;
    }

    public ConfigHandler(Map<String, RawPropertyData> map, Map<String, String> map2) {
        this(map, map2, false, null);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("config")) {
            String string4 = attributes.getValue("extends");
            if (string4 != null) {
                this.mergeConfigs(string4, true);
                this.replaceDuplicates = true;
            }
        } else if (string3.equals("include")) {
            String string5 = attributes.getValue("file");
            this.mergeConfigs(string5, false);
        } else if (string3.equals("extendwith")) {
            String string6 = attributes.getValue("file");
            this.mergeConfigs(string6, true);
        } else if (string3.equals("component")) {
            String string7 = attributes.getValue("name");
            String string8 = attributes.getValue("type");
            if (this.rpdMap.get(string7) != null && !this.replaceDuplicates) {
                throw new SAXParseException("duplicate definition for " + string7, this.locator);
            }
            this.rpd = new RawPropertyData(string7, string8);
        } else if (string3.equals("property")) {
            String string9 = attributes.getValue("name");
            String string10 = attributes.getValue("value");
            if (attributes.getLength() != 2 || string9 == null || string10 == null) {
                throw new SAXParseException("property element must only have 'name' and 'value' attributes", this.locator);
            }
            if (this.rpd == null) {
                this.globalProperties.put(string9, string10);
            } else {
                if (this.rpd.contains(string9) && !this.replaceDuplicates) {
                    throw new SAXParseException("Duplicate property: " + string9, this.locator);
                }
                this.rpd.add(string9, string10);
            }
        } else if (string3.equals("propertylist")) {
            this.itemListName = attributes.getValue("name");
            if (attributes.getLength() != 1 || this.itemListName == null) {
                throw new SAXParseException("list element must only have the 'name'  attribute", this.locator);
            }
            this.itemList = new ArrayList<String>();
        } else if (string3.equals("item")) {
            if (attributes.getLength() != 0) {
                throw new SAXParseException("unknown 'item' attribute", this.locator);
            }
            this.curItem = new StringBuilder();
        } else {
            throw new SAXParseException("Unknown element '" + string3 + '\'', this.locator);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXParseException {
        if (this.curItem != null) {
            this.curItem.append(cArray, n, n2);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXParseException {
        if (string3.equals("component")) {
            this.rpdMap.put(this.rpd.getName(), this.rpd);
            this.rpd = null;
        } else if (!string3.equals("property")) {
            if (string3.equals("propertylist")) {
                if (this.rpd.contains(this.itemListName)) {
                    throw new SAXParseException("Duplicate property: " + this.itemListName, this.locator);
                }
                this.rpd.add(this.itemListName, this.itemList);
                this.itemList = null;
            } else if (string3.equals("item")) {
                this.itemList.add(this.curItem.toString().trim());
                this.curItem = null;
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private void mergeConfigs(String string, boolean bl) {
        try {
            File file = new File(this.baseURL.toURI().getPath()).getParentFile();
            URL uRL = new File(file.getPath() + File.separatorChar + string).toURI().toURL();
            Logger logger = Logger.getLogger(ConfigHandler.class.getSimpleName());
            logger.fine((bl ? "extending" : "including") + " config:" + uRL.toURI());
            SaxLoader saxLoader = new SaxLoader(uRL, this.globalProperties, this.rpdMap, bl);
            saxLoader.load();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error while processing <include file=\"" + string + "\">: " + iOException, iOException);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
    }
}

