/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props;

import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationChangeListener;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.InternalConfigurationException;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.RawPropertyData;
import edu.cmu.sphinx.util.props.SaxLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ConfigurationManager
implements Cloneable {
    private List<ConfigurationChangeListener> changeListeners = new ArrayList<ConfigurationChangeListener>();
    private Map<String, PropertySheet> symbolTable = new LinkedHashMap<String, PropertySheet>();
    private Map<String, RawPropertyData> rawPropertyMap = new HashMap<String, RawPropertyData>();
    private Map<String, String> globalProperties = new HashMap<String, String>();
    private boolean showCreations;
    private URL configURL;

    public ConfigurationManager() {
    }

    public ConfigurationManager(String string) throws PropertyException {
        this(ConfigurationManagerUtils.getURL(new File(string)));
    }

    public ConfigurationManager(URL uRL) throws PropertyException {
        this.configURL = uRL;
        try {
            this.rawPropertyMap = new SaxLoader(uRL, this.globalProperties).load();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        ConfigurationManagerUtils.applySystemProperties(this.rawPropertyMap, this.globalProperties);
        ConfigurationManagerUtils.configureLogger(this);
        String string = this.globalProperties.get("showCreations");
        if (string != null) {
            this.showCreations = "true".equals(string);
        }
    }

    public PropertySheet getPropertySheet(String string) {
        RawPropertyData rawPropertyData;
        if (!this.symbolTable.containsKey(string) && (rawPropertyData = this.rawPropertyMap.get(string)) != null) {
            String string2 = rawPropertyData.getClassName();
            try {
                Class<?> clazz = Class.forName(string2);
                PropertySheet propertySheet = new PropertySheet(clazz.asSubclass(Configurable.class), string, this, rawPropertyData);
                this.symbolTable.put(string, propertySheet);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("class not found !" + classNotFoundException);
            }
            catch (ClassCastException classCastException) {
                System.err.println("can not cast class !" + classCastException);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                System.err.println("couldn't load class !" + exceptionInInitializerError);
            }
        }
        return this.symbolTable.get(string);
    }

    public Collection<String> getInstanceNames(Class<? extends Configurable> clazz) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PropertySheet propertySheet : this.symbolTable.values()) {
            if (!propertySheet.isInstanciated() || !ConfigurationManagerUtils.isDerivedClass(propertySheet.getConfigurableClass(), clazz)) continue;
            arrayList.add(propertySheet.getInstanceName());
        }
        return arrayList;
    }

    public Set<String> getComponentNames() {
        return this.rawPropertyMap.keySet();
    }

    public <C extends Configurable> C lookup(String string) throws InternalConfigurationException {
        PropertySheet propertySheet = this.getPropertySheet(string = this.getStrippedComponentName(string));
        if (propertySheet == null) {
            return null;
        }
        if (this.showCreations) {
            this.getRootLogger().config("Creating: " + string);
        }
        return (C)propertySheet.getOwner();
    }

    public <C extends Configurable> C lookup(Class<C> clazz) {
        List<PropertySheet> list = this.getPropSheets(clazz);
        if (list.isEmpty()) {
            return null;
        }
        assert (list.size() == 1);
        return (C)((Configurable)clazz.cast(this.lookup(list.get(0).getInstanceName())));
    }

    public List<PropertySheet> getPropSheets(Class<? extends Configurable> clazz) {
        ArrayList<PropertySheet> arrayList = new ArrayList<PropertySheet>();
        for (PropertySheet propertySheet : this.symbolTable.values()) {
            if (!ConfigurationManagerUtils.isDerivedClass(propertySheet.getConfigurableClass(), clazz)) continue;
            arrayList.add(propertySheet);
        }
        return arrayList;
    }

    public void addConfigurable(Class<? extends Configurable> clazz, String string) {
        this.addConfigurable(clazz, string, new HashMap<String, Object>());
    }

    public void addConfigurable(Class<? extends Configurable> clazz, String string, Map<String, Object> map) {
        if (string == null) {
            string = clazz.getName();
        }
        if (this.symbolTable.containsKey(string)) {
            throw new IllegalArgumentException("tried to override existing component name : " + string);
        }
        PropertySheet propertySheet = ConfigurationManager.getPropSheetInstanceFromClass(clazz, map, string, this);
        this.symbolTable.put(string, propertySheet);
        this.rawPropertyMap.put(string, new RawPropertyData(string, clazz.getName()));
        for (ConfigurationChangeListener configurationChangeListener : this.changeListeners) {
            configurationChangeListener.componentAdded(this, propertySheet);
        }
    }

    public void addConfigurable(Configurable configurable, String string) {
        if (this.symbolTable.containsKey(string)) {
            throw new IllegalArgumentException("tried to override existing component name");
        }
        RawPropertyData rawPropertyData = new RawPropertyData(string, configurable.getClass().getName());
        PropertySheet propertySheet = new PropertySheet(configurable, string, rawPropertyData, this);
        this.symbolTable.put(string, propertySheet);
        this.rawPropertyMap.put(string, rawPropertyData);
        for (ConfigurationChangeListener configurationChangeListener : this.changeListeners) {
            configurationChangeListener.componentAdded(this, propertySheet);
        }
    }

    public void renameConfigurable(String string, String string2) {
        PropertySheet propertySheet = this.getPropertySheet(string);
        if (propertySheet == null) {
            throw new RuntimeException("no configurable (to be renamed) named " + string + " is contained in the CM");
        }
        ConfigurationManagerUtils.renameComponent(this, string, string2);
        this.symbolTable.remove(string);
        this.symbolTable.put(string2, propertySheet);
        RawPropertyData rawPropertyData = this.rawPropertyMap.remove(string);
        this.rawPropertyMap.put(string2, new RawPropertyData(string2, rawPropertyData.getClassName(), rawPropertyData.getProperties()));
        this.fireRenamedConfigurable(string, string2);
    }

    public void removeConfigurable(String string) {
        assert (this.getComponentNames().contains(string));
        PropertySheet propertySheet = this.symbolTable.remove(string);
        this.rawPropertyMap.remove(string);
        for (ConfigurationChangeListener configurationChangeListener : this.changeListeners) {
            configurationChangeListener.componentRemoved(this, propertySheet);
        }
    }

    public void addSubConfiguration(ConfigurationManager configurationManager) {
        this.addSubConfiguration(configurationManager, false);
    }

    public void addSubConfiguration(ConfigurationManager configurationManager, boolean bl) {
        Set<String> set = this.getComponentNames();
        for (String object : configurationManager.getComponentNames()) {
            if (!set.contains(object)) continue;
            if (bl && !this.getPropertySheet(object).isInstanciated()) {
                PropertySheet propertySheet = configurationManager.getPropertySheet(object);
                this.symbolTable.put(object, propertySheet);
                this.rawPropertyMap.put(object, new RawPropertyData(object, propertySheet.getConfigurableClass().getSimpleName()));
                continue;
            }
            throw new RuntimeException(object + " is already registered to system configuration");
        }
        for (String string : configurationManager.globalProperties.keySet()) {
            if (!this.globalProperties.containsKey(string) || System.getProperties().containsKey(string) || bl) continue;
            throw new RuntimeException(string + " is already registered as global property");
        }
        this.globalProperties.putAll(configurationManager.globalProperties);
        for (PropertySheet propertySheet : configurationManager.symbolTable.values()) {
            propertySheet.setCM(this);
        }
        this.symbolTable.putAll(configurationManager.symbolTable);
        this.rawPropertyMap.putAll(configurationManager.rawPropertyMap);
    }

    public Map<String, String> getGlobalProperties() {
        return new HashMap<String, String>(this.globalProperties);
    }

    public String getGlobalProperty(String string) {
        String string2 = this.globalProperties.get(string);
        return string2 != null ? string2.toString() : null;
    }

    public String getGloPropReference(String string) {
        return this.globalProperties.get(string);
    }

    public URL getConfigURL() {
        return this.configURL;
    }

    public void setGlobalProperty(String string, String string2) {
        if (string2 == null) {
            this.globalProperties.remove(string);
        } else {
            this.globalProperties.put(string, string2);
        }
        for (String string3 : this.getInstanceNames(Configurable.class)) {
            PropertySheet propertySheet = this.getPropertySheet(string3);
            if (!propertySheet.isInstanciated()) continue;
            try {
                propertySheet.getOwner().newProperties(propertySheet);
            }
            catch (PropertyException propertyException) {
                propertyException.printStackTrace();
            }
        }
    }

    public String getStrippedComponentName(String string) {
        assert (string != null);
        while (string.startsWith("$")) {
            string = this.globalProperties.get(ConfigurationManagerUtils.stripGlobalSymbol(string)).toString();
        }
        return string;
    }

    public void addConfigurationChangeListener(ConfigurationChangeListener configurationChangeListener) {
        if (configurationChangeListener == null) {
            return;
        }
        this.changeListeners.add(configurationChangeListener);
    }

    public void removeConfigurationChangeListener(ConfigurationChangeListener configurationChangeListener) {
        if (configurationChangeListener == null) {
            return;
        }
        this.changeListeners.remove(configurationChangeListener);
    }

    void fireConfChanged(String string, String string2) {
        assert (this.getComponentNames().contains(string));
        for (ConfigurationChangeListener configurationChangeListener : this.changeListeners) {
            configurationChangeListener.configurationChanged(string, string2, this);
        }
    }

    void fireRenamedConfigurable(String string, String string2) {
        assert (this.getComponentNames().contains(string2));
        for (ConfigurationChangeListener configurationChangeListener : this.changeListeners) {
            configurationChangeListener.componentRenamed(this, this.getPropertySheet(string2), string);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConfigurationManager)) {
            return false;
        }
        ConfigurationManager configurationManager = (ConfigurationManager)object;
        Set<String> set = this.getComponentNames();
        if (!set.equals(configurationManager.getComponentNames())) {
            return false;
        }
        for (String string : set) {
            PropertySheet propertySheet = this.getPropertySheet(string);
            PropertySheet propertySheet2 = configurationManager.getPropertySheet(string);
            if (propertySheet2.equals(propertySheet)) continue;
            return false;
        }
        return configurationManager.getGlobalProperties().equals(this.getGlobalProperties());
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 1;
    }

    public ConfigurationManager clone() throws CloneNotSupportedException {
        ConfigurationManager configurationManager = (ConfigurationManager)super.clone();
        configurationManager.changeListeners = new ArrayList<ConfigurationChangeListener>();
        configurationManager.symbolTable = new LinkedHashMap<String, PropertySheet>();
        for (Map.Entry<String, PropertySheet> entry : this.symbolTable.entrySet()) {
            configurationManager.symbolTable.put(entry.getKey(), entry.getValue().clone());
        }
        configurationManager.globalProperties = new HashMap<String, String>(this.globalProperties);
        configurationManager.rawPropertyMap = new HashMap<String, RawPropertyData>(this.rawPropertyMap);
        return configurationManager;
    }

    public static <C extends Configurable> C getInstance(Class<C> clazz) throws PropertyException {
        return ConfigurationManager.getInstance(clazz, new HashMap<String, Object>());
    }

    public static <C extends Configurable> C getInstance(Class<C> clazz, Map<String, Object> map) throws PropertyException {
        return ConfigurationManager.getInstance(clazz, map, null);
    }

    public static <C extends Configurable> C getInstance(Class<C> clazz, Map<String, Object> map, String string) throws PropertyException {
        PropertySheet propertySheet = ConfigurationManager.getPropSheetInstanceFromClass(clazz, map, string, new ConfigurationManager());
        Configurable configurable = propertySheet.getOwner();
        return (C)((Configurable)clazz.cast(configurable));
    }

    private static PropertySheet getPropSheetInstanceFromClass(Class<? extends Configurable> clazz, Map<String, Object> map, String string, ConfigurationManager configurationManager) {
        RawPropertyData rawPropertyData = new RawPropertyData(string, clazz.getName());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof Class) {
                object = ((Class)object).getName();
            }
            rawPropertyData.getProperties().put(entry.getKey(), object);
        }
        return new PropertySheet(clazz, string, configurationManager, rawPropertyData);
    }

    public Logger getRootLogger() {
        return Logger.getLogger(ConfigurationManagerUtils.getLogPrefix(this));
    }
}

