/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props;

import edu.cmu.sphinx.util.SphinxLogFormatter;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.InternalConfigurationException;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.RawPropertyData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ConfigurationManagerUtils {
    private static final Pattern globalSymbolPattern = Pattern.compile("\\$\\{(\\w+)\\}");
    public static final String GLOBAL_COMMON_LOGLEVEL = "logLevel";
    public static final String CM_FILE_SUFFIX = ".sxl";
    static final Pattern jarPattern = Pattern.compile("resource:(.*)", 2);

    private ConfigurationManagerUtils() {
    }

    public boolean validateConfiguration(ConfigurationManager configurationManager) {
        for (String string : configurationManager.getComponentNames()) {
            if (configurationManager.getPropertySheet(string).validate()) continue;
            return false;
        }
        return true;
    }

    public static String stripGlobalSymbol(String string) {
        Matcher matcher = globalSymbolPattern.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return string;
    }

    public static void editConfig(ConfigurationManager configurationManager, String string) {
        PropertySheet propertySheet = configurationManager.getPropertySheet(string);
        if (propertySheet == null) {
            System.out.println("No component: " + string);
            return;
        }
        System.out.println(string + ':');
        Collection<String> collection = propertySheet.getRegisteredProperties();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        for (String string2 : collection) {
            try {
                Object object = propertySheet.getRaw(string2);
                if (object instanceof List) continue;
                String string3 = object instanceof String ? (String)object : "DEFAULT";
                boolean bl = false;
                while (!bl) {
                    System.out.print("  " + string2 + " [" + string3 + "]: ");
                    String string4 = bufferedReader.readLine();
                    if (string4.isEmpty()) {
                        bl = true;
                        continue;
                    }
                    if (string4.equals(".")) {
                        return;
                    }
                    configurationManager.getPropertySheet(string).setRaw(string2, string4);
                    bl = true;
                }
            }
            catch (IOException iOException) {
                System.out.println("Trouble reading input");
                return;
            }
        }
    }

    public static String getLogPrefix(ConfigurationManager configurationManager) {
        if (configurationManager.getConfigURL() != null) {
            return new File(configurationManager.getConfigURL().getFile()).getName().replace(CM_FILE_SUFFIX, "").replace(".xml", "") + '.';
        }
        return "S4CM.";
    }

    public static void configureLogger(ConfigurationManager configurationManager) {
        if (System.getProperty("java.util.logging.config.class") != null || System.getProperty("java.util.logging.config.file") != null) {
            return;
        }
        String string = ConfigurationManagerUtils.getLogPrefix(configurationManager);
        Logger logger = Logger.getLogger(string.substring(0, string.length() - 1));
        Level level = Logger.getLogger("").getLevel();
        ConfigurationManagerUtils.configureLogger(logger);
        String string2 = configurationManager.getGlobalProperty(GLOBAL_COMMON_LOGLEVEL);
        if (string2 == null) {
            string2 = Level.WARNING.getName();
        }
        logger.setLevel(Level.parse(string2));
        Logger.getLogger("").setLevel(level);
    }

    public static void configureLogger(Logger logger) {
        logger.setUseParentHandlers(false);
        boolean bl = false;
        for (Handler handler : logger.getHandlers()) {
            if (!(handler.getFormatter() instanceof SphinxLogFormatter)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new SphinxLogFormatter());
            logger.addHandler(consoleHandler);
        }
    }

    public static Map<String, String> fixDuplicateNames(ConfigurationManager configurationManager, ConfigurationManager configurationManager2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator<String> iterator = configurationManager2.getComponentNames().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = iterator.next();
            int n = 0;
            while (configurationManager.getComponentNames().contains(string2) || configurationManager2.getComponentNames().contains(string2) && !string2.equals(string)) {
                string2 = string + ++n;
            }
            configurationManager2.renameConfigurable(string, string2);
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public static String toXML(ConfigurationManager configurationManager) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        stringBuilder.append("\n<!--    Sphinx-4 Configuration file--> \n\n");
        stringBuilder.append("<config>");
        Pattern pattern = Pattern.compile("\\$\\{(\\w+)\\}");
        Map<String, String> map = configurationManager.getGlobalProperties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            Matcher matcher = pattern.matcher(string);
            string = matcher.matches() ? matcher.group(1) : string;
            stringBuilder.append("\n\t<property name=\"").append(string).append("\" value=\"").append(entry.getValue()).append("\"/>");
        }
        for (String string : configurationManager.getComponentNames()) {
            stringBuilder.append("\n\n").append(ConfigurationManagerUtils.propSheet2XML(string, configurationManager.getPropertySheet(string)));
        }
        stringBuilder.append("\n</config>");
        return stringBuilder.toString();
    }

    private static String propSheet2XML(String string, PropertySheet propertySheet) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t<component name=\"").append(string).append("\" type=\"").append(propertySheet.getConfigurableClass().getName()).append("\">");
        block3: for (String string2 : propertySheet.getRegisteredProperties()) {
            String string3 = "\n\t\t<property name=\"" + string2 + "\" ";
            if (propertySheet.getRawNoReplacement(string2) == null) continue;
            switch (propertySheet.getType(string2)) {
                case COMPONENT_LIST: {
                    stringBuilder.append("\n\t\t<propertylist name=\"").append(string2).append("\">");
                    List<String> list = ConfigurationManagerUtils.toStringList(propertySheet.getRawNoReplacement(string2));
                    for (String string4 : list) {
                        stringBuilder.append("\n\t\t\t<item>").append(string4).append("</item>");
                    }
                    stringBuilder.append("\n\t\t</propertylist>");
                    continue block3;
                }
            }
            stringBuilder.append(string3).append("value=\"").append(propertySheet.getRawNoReplacement(string2)).append("\"/>");
        }
        stringBuilder.append("\n\t</component>\n\n");
        return stringBuilder.toString();
    }

    public static void save(ConfigurationManager configurationManager, File file) {
        if (!file.getName().endsWith(CM_FILE_SUFFIX)) {
            System.err.println("WARNING: Serialized s4-configuration should have the suffix '.sxl'");
        }
        assert (configurationManager != null);
        try {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8")));
            String string = ConfigurationManagerUtils.toXML(configurationManager);
            printWriter.print(string);
            printWriter.flush();
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public static void showConfig(ConfigurationManager configurationManager) {
        System.out.println(" ============ config ============= ");
        for (String string : configurationManager.getInstanceNames(Configurable.class)) {
            ConfigurationManagerUtils.showConfig(configurationManager, string);
        }
    }

    public static void showConfig(ConfigurationManager configurationManager, String string) {
        if (!configurationManager.getComponentNames().contains(string)) {
            System.out.println("No component: " + string);
            return;
        }
        System.out.println(string + ':');
        PropertySheet propertySheet = configurationManager.getPropertySheet(string);
        for (String string2 : propertySheet.getRegisteredProperties()) {
            System.out.print("    " + string2 + " = ");
            Object object = propertySheet.getRaw(string2);
            if (object instanceof String) {
                System.out.println(object);
                continue;
            }
            if (object instanceof List) {
                List list = (List)object;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    System.out.print(iterator.next());
                    if (!iterator.hasNext()) continue;
                    System.out.print(", ");
                }
                System.out.println();
                continue;
            }
            System.out.println("[DEFAULT]");
        }
    }

    static void applySystemProperties(Map<String, RawPropertyData> map, Map<String, String> map2) throws PropertyException {
        Properties properties = System.getProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            int n = string.indexOf(91);
            int n2 = string.indexOf(93);
            if (n > 0 && n2 > n) {
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + 1, n2);
                RawPropertyData rawPropertyData = map.get(string3);
                if (rawPropertyData != null) {
                    rawPropertyData.add(string4, string2);
                    continue;
                }
                throw new InternalConfigurationException(string3, string, "System property attempting to set parameter  for unknown component " + string3 + " (" + string + ')');
            }
            if (string.indexOf(46) != -1) continue;
            map2.put(string, string2);
        }
    }

    static void renameComponent(ConfigurationManager configurationManager, String string, String string2) {
        assert (configurationManager != null);
        assert (string != null && string2 != null);
        if (configurationManager.getPropertySheet(string) == null) {
            throw new RuntimeException("no configurable (to be renamed) named " + string + " is contained in the CM");
        }
        for (String object : configurationManager.getComponentNames()) {
            PropertySheet propertySheet = configurationManager.getPropertySheet(object);
            block5: for (String string3 : propertySheet.getRegisteredProperties()) {
                if (propertySheet.getRawNoReplacement(string3) == null) continue;
                switch (propertySheet.getType(string3)) {
                    case COMPONENT_LIST: {
                        List<String> list = ConfigurationManagerUtils.toStringList(propertySheet.getRawNoReplacement(string3));
                        for (int i = 0; i < list.size(); ++i) {
                            String string4 = list.get(i);
                            if (!string4.equals(string)) continue;
                            list.set(i, string2);
                        }
                        continue block5;
                    }
                    case COMPONENT: {
                        if (!propertySheet.getRawNoReplacement(string3).equals(string)) break;
                        propertySheet.setRaw(string3, string2);
                    }
                }
            }
        }
        PropertySheet propertySheet = configurationManager.getPropertySheet(string);
        propertySheet.setInstanceName(string2);
        for (Map.Entry<String, String> entry : configurationManager.getGlobalProperties().entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            configurationManager.setGlobalProperty(entry.getKey(), string2);
        }
    }

    public static URL getResource(String string, PropertySheet propertySheet) throws PropertyException {
        String string2 = propertySheet.getString(string);
        if (string2 == null) {
            throw new InternalConfigurationException(propertySheet.getInstanceName(), string, "Required resource property '" + string + "' not set");
        }
        try {
            URL uRL = ConfigurationManagerUtils.resourceToURL(string2);
            if (uRL == null) {
                throw new InternalConfigurationException(propertySheet.getInstanceName(), string, "Can't locate " + string2);
            }
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new InternalConfigurationException(malformedURLException, propertySheet.getInstanceName(), string, "Bad URL " + string2 + malformedURLException.getMessage());
        }
    }

    public static URL resourceToURL(String string) throws MalformedURLException {
        Matcher matcher = jarPattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            return ConfigurationManagerUtils.class.getResource(string2);
        }
        if (string.indexOf(58) == -1) {
            string = "file:" + string;
        }
        return new URL(string);
    }

    public static boolean isDerivedClass(Class<?> clazz, Class<?> clazz2) {
        return clazz2.isAssignableFrom(clazz);
    }

    public static boolean isImplementingInterface(Class<?> clazz, Class<?> clazz2) {
        assert (clazz2.isInterface());
        Class<?> clazz3 = clazz.getSuperclass();
        if (clazz3 != null && ConfigurationManagerUtils.isImplementingInterface(clazz3, clazz2)) {
            return true;
        }
        for (Class<?> clazz4 : clazz.getInterfaces()) {
            if (!clazz4.equals(clazz2) && !ConfigurationManagerUtils.isImplementingInterface(clazz4, clazz2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubClass(Class<?> clazz, Class<?> clazz2) {
        while (clazz != null && !clazz.equals(Object.class)) {
            if ((clazz = clazz.getSuperclass()) == null || !clazz.equals(clazz2)) continue;
            return true;
        }
        return false;
    }

    public static ConfigurationManager getPropertyManager(PropertySheet propertySheet) {
        return propertySheet.getPropertyManager();
    }

    public static Map<String, List<PropertySheet>> listAllsPropNames(ConfigurationManager configurationManager) {
        HashMap<String, List<PropertySheet>> hashMap = new HashMap<String, List<PropertySheet>>();
        for (String string : configurationManager.getComponentNames()) {
            PropertySheet propertySheet = configurationManager.getPropertySheet(string);
            for (String string2 : propertySheet.getRegisteredProperties()) {
                if (!hashMap.containsKey(string2)) {
                    hashMap.put(string2, new ArrayList());
                }
                ((List)hashMap.get(string2)).add(propertySheet);
            }
        }
        return hashMap;
    }

    public static void dumpPropStructure(ConfigurationManager configurationManager) {
        Map<String, List<PropertySheet>> map = ConfigurationManagerUtils.listAllsPropNames(configurationManager);
        System.out.println("Property-structure of '" + configurationManager.getConfigURL() + "':");
        System.out.println("\nUnambiguous properties = ");
        for (Map.Entry<String, List<PropertySheet>> entry : map.entrySet()) {
            if (entry.getValue().size() != 1) continue;
            System.out.print(entry.getKey() + ", ");
        }
        System.out.println("\n\nAmbiguous properties: ");
        for (Map.Entry<String, List<PropertySheet>> entry : map.entrySet()) {
            if (entry.getValue().size() == 1) continue;
            System.out.print(entry.getKey() + '=');
            for (PropertySheet propertySheet : entry.getValue()) {
                System.out.print(propertySheet.getInstanceName() + ", ");
            }
            System.out.println();
        }
    }

    public static void setProperty(ConfigurationManager configurationManager, String string, String string2) {
        String string3;
        assert (string2 != null);
        Map<String, List<PropertySheet>> map = ConfigurationManagerUtils.listAllsPropNames(configurationManager);
        Set<String> set = configurationManager.getComponentNames();
        if (!(map.containsKey(string) || string.contains("->") || set.contains(string))) {
            throw new RuntimeException("No property or configurable '" + string + "' in configuration '" + configurationManager.getConfigURL() + "'!");
        }
        if (set.contains(string)) {
            try {
                Class<Configurable> clazz = Class.forName(string2).asSubclass(Configurable.class);
                ConfigurationManagerUtils.setClass(configurationManager.getPropertySheet(string), clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
            return;
        }
        if (!string.contains("->") && map.get(string).size() > 1) {
            throw new RuntimeException("Property-name '" + string + "' is ambiguous with respect to configuration '" + configurationManager.getConfigURL() + "'. Use 'componentName->propName' to disambiguate your request.");
        }
        if (string.contains("->")) {
            String[] stringArray = string.split("->");
            string3 = stringArray[0];
            string = stringArray[1];
        } else {
            string3 = map.get(string).get(0).getInstanceName();
        }
        ConfigurationManagerUtils.setProperty(configurationManager, string3, string, string2);
    }

    public static void setProperty(ConfigurationManager configurationManager, String string, String string2, String string3) {
        PropertySheet propertySheet = configurationManager.getPropertySheet(string);
        if (propertySheet == null) {
            throw new RuntimeException("Component '" + string2 + "' is not registered to this system configuration '");
        }
        if (string3.equals("null")) {
            string3 = null;
        }
        switch (propertySheet.getType(string2)) {
            case BOOLEAN: {
                propertySheet.setBoolean(string2, Boolean.parseBoolean(string3));
                break;
            }
            case DOUBLE: {
                propertySheet.setDouble(string2, Double.parseDouble(string3));
                break;
            }
            case INT: {
                propertySheet.setInt(string2, Integer.parseInt(string3));
                break;
            }
            case STRING: {
                propertySheet.setString(string2, string3);
                break;
            }
            case COMPONENT: {
                propertySheet.setComponent(string2, string3, null);
                break;
            }
            case COMPONENT_LIST: {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string4 : string3.split(";")) {
                    arrayList.add(string4.trim());
                }
                propertySheet.setComponentList(string2, arrayList, null);
                break;
            }
            default: {
                throw new RuntimeException("unknown property-type");
            }
        }
    }

    public static URL getURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static Collection<String> getNonInstaniatedComps(ConfigurationManager configurationManager) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : configurationManager.getComponentNames()) {
            if (configurationManager.getPropertySheet(string).isInstanciated()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static void setClass(PropertySheet propertySheet, Class<? extends Configurable> clazz) {
        if (propertySheet.isInstanciated()) {
            throw new RuntimeException("configurable " + propertySheet.getInstanceName() + "has already been instantiated");
        }
        propertySheet.setConfigurableClass(clazz);
    }

    public static List<String> toStringList(Object object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!(object instanceof List)) {
            return null;
        }
        for (Object e : (List)object) {
            if (!(e instanceof String)) continue;
            arrayList.add((String)e);
        }
        return arrayList;
    }
}

