/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props;

import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import edu.cmu.sphinx.util.props.InternalConfigurationException;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertyType;
import edu.cmu.sphinx.util.props.RawPropertyData;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4ComponentList;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4PropWrapper;
import edu.cmu.sphinx.util.props.S4Property;
import edu.cmu.sphinx.util.props.S4String;
import edu.cmu.sphinx.util.props.S4StringList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertySheet
implements Cloneable {
    public static final String COMP_LOG_LEVEL = "logLevel";
    private Map<String, S4PropWrapper> registeredProperties = new HashMap<String, S4PropWrapper>();
    private Map<String, Object> propValues = new HashMap<String, Object>();
    private Map<String, Object> rawProps = new HashMap<String, Object>();
    private ConfigurationManager cm;
    private Configurable owner;
    private Class<? extends Configurable> ownerClass;
    private String instanceName;

    public PropertySheet(Configurable configurable, String string, RawPropertyData rawPropertyData, ConfigurationManager configurationManager) {
        this(configurable.getClass(), string, configurationManager, rawPropertyData);
        this.owner = configurable;
    }

    public PropertySheet(Class<? extends Configurable> clazz, String string, ConfigurationManager configurationManager, RawPropertyData rawPropertyData) {
        this.ownerClass = clazz;
        this.cm = configurationManager;
        this.instanceName = string;
        PropertySheet.parseClass(clazz);
        this.setConfigurableClass(clazz);
        Map<String, Object> map = rawPropertyData.flatten(configurationManager).getProperties();
        this.rawProps = new HashMap<String, Object>(rawPropertyData.getProperties());
        for (String string2 : this.rawProps.keySet()) {
            this.propValues.put(string2, map.get(string2));
        }
    }

    private void registerProperty(String string, S4PropWrapper s4PropWrapper) {
        if (s4PropWrapper == null || string == null) {
            throw new InternalConfigurationException(this.getInstanceName(), string, "property or its value is null");
        }
        if (!this.registeredProperties.containsKey(string)) {
            this.registeredProperties.put(string, s4PropWrapper);
        }
        if (!this.propValues.containsKey(string)) {
            this.propValues.put(string, null);
            this.rawProps.put(string, null);
        }
    }

    public S4PropWrapper getProperty(String string, Class<?> clazz) throws PropertyException {
        if (!this.propValues.containsKey(string)) {
            throw new InternalConfigurationException(this.getInstanceName(), string, "Unknown property '" + string + "' ! Make sure that you've annotated it.");
        }
        S4PropWrapper s4PropWrapper = this.registeredProperties.get(string);
        if (s4PropWrapper == null) {
            throw new InternalConfigurationException(this.getInstanceName(), string, "Property is not an annotated property of " + this.getConfigurableClass());
        }
        try {
            clazz.cast(s4PropWrapper.getAnnotation());
        }
        catch (ClassCastException classCastException) {
            throw new InternalConfigurationException(classCastException, this.getInstanceName(), string, "Property annotation " + s4PropWrapper.getAnnotation() + " doesn't match the required type " + clazz.getName());
        }
        return s4PropWrapper;
    }

    public String getString(String string) throws PropertyException {
        S4PropWrapper s4PropWrapper = this.getProperty(string, S4String.class);
        S4String s4String = (S4String)s4PropWrapper.getAnnotation();
        if (this.propValues.get(string) == null) {
            boolean bl;
            boolean bl2 = bl = !s4String.defaultValue().equals("nullnullnull");
            if (s4String.mandatory() && !bl) {
                throw new InternalConfigurationException(this.getInstanceName(), string, "mandatory property is not set!");
            }
            this.propValues.put(string, bl ? s4String.defaultValue() : null);
        }
        String string2 = this.flattenProp(string);
        List<String> list = Arrays.asList(s4String.range());
        if (!list.isEmpty() && !list.contains(string2)) {
            throw new InternalConfigurationException(this.getInstanceName(), string, " is not in range (" + list + ')');
        }
        return string2;
    }

    private String flattenProp(String string) {
        Object object = this.propValues.get(string);
        return object instanceof String ? (String)object : null;
    }

    public int getInt(String string) throws PropertyException {
        Object object;
        S4PropWrapper s4PropWrapper = this.getProperty(string, S4Integer.class);
        S4Integer s4Integer = (S4Integer)s4PropWrapper.getAnnotation();
        if (this.propValues.get(string) == null) {
            boolean bl;
            boolean bl2 = bl = s4Integer.defaultValue() != -918273645;
            if (s4Integer.mandatory()) {
                if (!bl) {
                    throw new InternalConfigurationException(this.getInstanceName(), string, "mandatory property is not set!");
                }
            } else if (!bl) {
                throw new InternalConfigurationException(this.getInstanceName(), string, "no default value for non-mandatory property");
            }
            this.propValues.put(string, s4Integer.defaultValue());
        }
        Integer n = (object = this.propValues.get(string)) instanceof Integer ? (Integer)object : Integer.decode(this.flattenProp(string));
        int[] nArray = s4Integer.range();
        if (nArray.length != 2) {
            throw new InternalConfigurationException(this.getInstanceName(), string, Arrays.toString(nArray) + " is not of expected range type, which is {minValue, maxValue)");
        }
        if (n < nArray[0] || n > nArray[1]) {
            throw new InternalConfigurationException(this.getInstanceName(), string, " is not in range (" + Arrays.toString(nArray) + ')');
        }
        return n;
    }

    public float getFloat(String string) throws PropertyException {
        return Double.valueOf(this.getDouble(string)).floatValue();
    }

    public double getDouble(String string) throws PropertyException {
        Object object;
        S4PropWrapper s4PropWrapper = this.getProperty(string, S4Double.class);
        S4Double s4Double = (S4Double)s4PropWrapper.getAnnotation();
        if (this.propValues.get(string) == null) {
            boolean bl;
            boolean bl2 = bl = s4Double.defaultValue() != -9.1827364512345E8;
            if (s4Double.mandatory()) {
                if (!bl) {
                    throw new InternalConfigurationException(this.getInstanceName(), string, "mandatory property is not set!");
                }
            } else if (!bl) {
                throw new InternalConfigurationException(this.getInstanceName(), string, "no default value for non-mandatory property");
            }
            this.propValues.put(string, s4Double.defaultValue());
        }
        Double d = (object = this.propValues.get(string)) instanceof Double ? (Double)object : (object instanceof Number ? Double.valueOf(((Number)object).doubleValue()) : Double.valueOf(this.flattenProp(string)));
        double[] dArray = s4Double.range();
        if (dArray.length != 2) {
            throw new InternalConfigurationException(this.getInstanceName(), string, Arrays.toString(dArray) + " is not of expected range type, which is {minValue, maxValue)");
        }
        if (d < dArray[0] || d > dArray[1]) {
            throw new InternalConfigurationException(this.getInstanceName(), string, " is not in range (" + Arrays.toString(dArray) + ')');
        }
        return d;
    }

    public Boolean getBoolean(String string) throws PropertyException {
        Object object;
        S4PropWrapper s4PropWrapper = this.getProperty(string, S4Boolean.class);
        S4Boolean s4Boolean = (S4Boolean)s4PropWrapper.getAnnotation();
        if (this.propValues.get(string) == null) {
            this.propValues.put(string, s4Boolean.defaultValue());
        }
        Boolean bl = (object = this.propValues.get(string)) instanceof Boolean ? (Boolean)object : Boolean.valueOf(this.flattenProp(string));
        return bl;
    }

    public Configurable getComponent(String string) throws PropertyException {
        S4PropWrapper s4PropWrapper = this.getProperty(string, S4Component.class);
        Configurable configurable = null;
        S4Component s4Component = (S4Component)s4PropWrapper.getAnnotation();
        Class<? extends Configurable> clazz = s4Component.type();
        Object object = this.propValues.get(string);
        if (object != null && object instanceof Configurable) {
            return (Configurable)object;
        }
        if (object != null && object instanceof String) {
            PropertySheet propertySheet = this.cm.getPropertySheet(this.flattenProp(string));
            if (propertySheet != null) {
                configurable = propertySheet.getOwner();
            } else {
                throw new InternalConfigurationException(this.getInstanceName(), string, "component '" + this.flattenProp(string) + "' is missing");
            }
        }
        if (configurable != null && !clazz.isInstance(configurable)) {
            throw new InternalConfigurationException(this.getInstanceName(), string, "mismatch between annotation and component type");
        }
        if (configurable != null) {
            this.propValues.put(string, configurable);
            return configurable;
        }
        configurable = this.getComponentFromAnnotation(string, s4Component);
        this.propValues.put(string, configurable);
        return configurable;
    }

    private Configurable getComponentFromAnnotation(String string, S4Component s4Component) {
        Class<? extends Configurable> clazz = s4Component.defaultClass();
        if (clazz.equals(Configurable.class) && s4Component.mandatory()) {
            throw new InternalConfigurationException(this.getInstanceName(), string, "mandatory property is not set!");
        }
        if (Modifier.isAbstract(clazz.getModifiers()) && s4Component.mandatory()) {
            throw new InternalConfigurationException(this.getInstanceName(), string, clazz.getName() + " is abstract!");
        }
        if (clazz.equals(Configurable.class)) {
            if (s4Component.mandatory()) {
                throw new InternalConfigurationException(this.getInstanceName(), string, this.instanceName + ": no default class defined for " + string);
            }
            return null;
        }
        Configurable configurable = ConfigurationManager.getInstance(clazz);
        if (configurable == null) {
            throw new InternalConfigurationException(this.getInstanceName(), string, "instantiation of referenenced configurable failed");
        }
        return configurable;
    }

    public Class<? extends Configurable> getComponentClass(String string) {
        Class<? extends Configurable> clazz = null;
        if (this.propValues.get(string) != null) {
            try {
                Class<?> clazz2 = Class.forName((String)this.propValues.get(string));
                clazz = clazz2.asSubclass(Configurable.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                PropertySheet propertySheet = this.cm.getPropertySheet(this.flattenProp(string));
                clazz = propertySheet.ownerClass;
            }
        } else {
            S4Component s4Component = (S4Component)this.registeredProperties.get(string).getAnnotation();
            clazz = s4Component.defaultClass();
            if (s4Component.mandatory()) {
                clazz = null;
            }
        }
        return clazz;
    }

    public List<String> getStringList(String string) throws InternalConfigurationException {
        this.getProperty(string, S4StringList.class);
        return ConfigurationManagerUtils.toStringList(this.propValues.get(string));
    }

    public <T> List<T> getComponentList(String string, Class<T> clazz) throws InternalConfigurationException {
        Object object;
        ArrayList arrayList;
        this.getProperty(string, S4ComponentList.class);
        List list = (List)this.propValues.get(string);
        assert (this.registeredProperties.get(string).getAnnotation() instanceof S4ComponentList);
        S4ComponentList s4ComponentList = (S4ComponentList)this.registeredProperties.get(string).getAnnotation();
        if (list == null) {
            arrayList = Arrays.asList(s4ComponentList.defaultList());
            object = new ArrayList();
            for (Class clazz2 : arrayList) {
                object.add(ConfigurationManager.getInstance(clazz2));
            }
            this.propValues.put(string, object);
        } else if (!list.isEmpty() && !(list.get(0) instanceof Configurable)) {
            arrayList = new ArrayList();
            for (Iterator iterator : list) {
                Object c = this.cm.lookup((String)((Object)iterator));
                if (c != null) {
                    arrayList.add(c);
                    continue;
                }
                if (s4ComponentList.beTolerant()) continue;
                throw new InternalConfigurationException(string, (String)((Object)iterator), "lookup of list-element '" + iterator + "' failed!");
            }
            this.propValues.put(string, arrayList);
        }
        arrayList = (ArrayList)this.propValues.get(string);
        object = new ArrayList();
        for (Object e : arrayList) {
            if (clazz.isInstance(e)) {
                ((ArrayList)object).add(clazz.cast(e));
                continue;
            }
            throw new InternalConfigurationException(this.getInstanceName(), string, "Not all elements have required type " + clazz + " Found one of type " + e.getClass());
        }
        return object;
    }

    public List<URL> getResourceList(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        String string2 = this.getString(string);
        if (string2 != null) {
            for (String string3 : string2.split(";")) {
                try {
                    URL uRL = new URL(string3);
                    arrayList.add(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException(string3 + " is not a valid URL.");
                }
            }
        }
        return arrayList;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    public boolean isInstanciated() {
        return this.owner != null;
    }

    public synchronized Configurable getOwner() {
        try {
            if (!this.isInstanciated()) {
                Collection<String> collection = this.getUndefinedMandatoryProps();
                if (!collection.isEmpty()) {
                    throw new InternalConfigurationException(this.getInstanceName(), collection.toString(), "not all mandatory properties are defined");
                }
                this.owner = this.ownerClass.newInstance();
                this.owner.newProperties(this);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalConfigurationException(illegalAccessException, this.getInstanceName(), null, "Can't access class " + this.ownerClass);
        }
        catch (InstantiationException instantiationException) {
            throw new InternalConfigurationException(instantiationException, this.getInstanceName(), null, "Can't instantiate class " + this.ownerClass);
        }
        return this.owner;
    }

    public Collection<String> getUndefinedMandatoryProps() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.getRegisteredProperties()) {
            Annotation annotation = this.registeredProperties.get(string).getAnnotation();
            boolean bl = false;
            if (annotation instanceof S4Component) {
                bl = ((S4Component)annotation).mandatory() && ((S4Component)annotation).defaultClass() == null;
            } else if (annotation instanceof S4String) {
                bl = ((S4String)annotation).mandatory() && ((S4String)annotation).defaultValue().equals("nullnullnull");
            } else if (annotation instanceof S4Integer) {
                bl = ((S4Integer)annotation).mandatory() && ((S4Integer)annotation).defaultValue() == -918273645;
            } else if (annotation instanceof S4Double) {
                boolean bl2 = bl = ((S4Double)annotation).mandatory() && ((S4Double)annotation).defaultValue() == -9.1827364512345E8;
            }
            if (!bl || this.rawProps.get(string) != null || this.propValues.get(string) != null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Class<? extends Configurable> getConfigurableClass() {
        return this.ownerClass;
    }

    void setConfigurableClass(Class<? extends Configurable> clazz) {
        this.ownerClass = clazz;
        if (this.isInstanciated()) {
            throw new RuntimeException("class is already instantiated");
        }
        HashSet<String> hashSet = new HashSet<String>();
        Map<Field, Annotation> map = PropertySheet.parseClass(this.ownerClass);
        for (Map.Entry<Field, Annotation> entry : map.entrySet()) {
            try {
                String string = (String)entry.getKey().get(null);
                assert (!hashSet.contains(string)) : "duplicate property-name for different properties: " + string + " for the class " + clazz;
                this.registerProperty(string, new S4PropWrapper(entry.getValue()));
                hashSet.add(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    public void setString(String string, String string2) throws PropertyException {
        if (!this.registeredProperties.containsKey(string)) {
            throw new InternalConfigurationException(this.getInstanceName(), string, '\'' + string + "' is not a registered string-property");
        }
        Annotation annotation = this.registeredProperties.get(string).getAnnotation();
        if (!(annotation instanceof S4String)) {
            throw new InternalConfigurationException(this.getInstanceName(), string, '\'' + string + "' is of type string");
        }
        this.applyConfigurationChange(string, string2, string2);
    }

    public void setInt(String string, int n) throws PropertyException {
        if (!this.registeredProperties.containsKey(string)) {
            throw new InternalConfigurationException(this.getInstanceName(), string, '\'' + string + "' is not a registered int-property");
        }
        Annotation annotation = this.registeredProperties.get(string).getAnnotation();
        if (!(annotation instanceof S4Integer)) {
            throw new InternalConfigurationException(this.getInstanceName(), string, '\'' + string + "' is of type int");
        }
        this.applyConfigurationChange(string, n, n);
    }

    public void setDouble(String string, double d) throws PropertyException {
        if (!this.registeredProperties.containsKey(string)) {
            throw new InternalConfigurationException(this.getInstanceName(), string, '\'' + string + "' is not a registered double-property");
        }
        Annotation annotation = this.registeredProperties.get(string).getAnnotation();
        if (!(annotation instanceof S4Double)) {
            throw new InternalConfigurationException(this.getInstanceName(), string, '\'' + string + "' is of type double");
        }
        this.applyConfigurationChange(string, d, d);
    }

    public void setBoolean(String string, Boolean bl) throws PropertyException {
        if (!this.registeredProperties.containsKey(string)) {
            throw new InternalConfigurationException(this.getInstanceName(), string, '\'' + string + "' is not a registered boolean-property");
        }
        Annotation annotation = this.registeredProperties.get(string).getAnnotation();
        if (!(annotation instanceof S4Boolean)) {
            throw new InternalConfigurationException(this.getInstanceName(), string, '\'' + string + "' is of type boolean");
        }
        this.applyConfigurationChange(string, bl, bl);
    }

    public void setComponent(String string, String string2, Configurable configurable) throws PropertyException {
        if (!this.registeredProperties.containsKey(string)) {
            throw new InternalConfigurationException(this.getInstanceName(), string, '\'' + string + "' is not a registered compontent");
        }
        Annotation annotation = this.registeredProperties.get(string).getAnnotation();
        if (!(annotation instanceof S4Component)) {
            throw new InternalConfigurationException(this.getInstanceName(), string, '\'' + string + "' is of type component");
        }
        this.applyConfigurationChange(string, string2, configurable);
    }

    public void setComponentList(String string, List<String> list, List<Configurable> list2) throws PropertyException {
        if (!this.registeredProperties.containsKey(string)) {
            throw new InternalConfigurationException(this.getInstanceName(), string, '\'' + string + "' is not a registered component-list");
        }
        Annotation annotation = this.registeredProperties.get(string).getAnnotation();
        if (!(annotation instanceof S4ComponentList)) {
            throw new InternalConfigurationException(this.getInstanceName(), string, '\'' + string + "' is of type component-list");
        }
        this.rawProps.put(string, list);
        this.propValues.put(string, list2);
        this.applyConfigurationChange(string, list, list2);
    }

    private void applyConfigurationChange(String string, Object object, Object object2) throws PropertyException {
        this.rawProps.put(string, object);
        this.propValues.put(string, object2 != null ? object2 : object);
        if (this.getInstanceName() != null) {
            this.cm.fireConfChanged(this.getInstanceName(), string);
        }
        if (this.owner != null) {
            this.owner.newProperties(this);
        }
    }

    void setRaw(String string, Object object) {
        this.rawProps.put(string, object);
        this.propValues.put(string, null);
    }

    public Object getRaw(String string) {
        return this.rawProps.get(string);
    }

    public Object getRawNoReplacement(String string) {
        return this.rawProps.get(string);
    }

    public PropertyType getType(String string) {
        S4PropWrapper s4PropWrapper = this.registeredProperties.get(string);
        if (s4PropWrapper == null) {
            throw new InternalConfigurationException(this.getInstanceName(), string, " is not a valid property of" + this.getConfigurableClass());
        }
        Annotation annotation = s4PropWrapper.getAnnotation();
        if (annotation instanceof S4Component) {
            return PropertyType.COMPONENT;
        }
        if (annotation instanceof S4ComponentList) {
            return PropertyType.COMPONENT_LIST;
        }
        if (annotation instanceof S4Integer) {
            return PropertyType.INT;
        }
        if (annotation instanceof S4Double) {
            return PropertyType.DOUBLE;
        }
        if (annotation instanceof S4Boolean) {
            return PropertyType.BOOLEAN;
        }
        if (annotation instanceof S4String) {
            return PropertyType.STRING;
        }
        throw new RuntimeException("Unknown property type");
    }

    ConfigurationManager getPropertyManager() {
        return this.cm;
    }

    public Logger getLogger() {
        String string = ConfigurationManagerUtils.getLogPrefix(this.cm) + this.ownerClass.getName();
        Logger logger = this.instanceName != null ? Logger.getLogger(string + '.' + this.instanceName) : Logger.getLogger(string);
        Object object = this.rawProps.get(COMP_LOG_LEVEL);
        if (object != null) {
            logger.setLevel(object instanceof String ? Level.parse((String)object) : (Level)object);
        }
        return logger;
    }

    public Collection<String> getRegisteredProperties() {
        return Collections.unmodifiableCollection(this.registeredProperties.keySet());
    }

    public void setCM(ConfigurationManager configurationManager) {
        this.cm = configurationManager;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PropertySheet)) {
            return false;
        }
        PropertySheet propertySheet = (PropertySheet)object;
        return this.rawProps.keySet().equals(propertySheet.rawProps.keySet());
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 1;
    }

    public String toString() {
        return this.getInstanceName() + "; isInstantiated=" + this.isInstanciated() + "; props=" + this.rawProps.keySet();
    }

    protected PropertySheet clone() throws CloneNotSupportedException {
        PropertySheet propertySheet = (PropertySheet)super.clone();
        propertySheet.registeredProperties = new HashMap<String, S4PropWrapper>(this.registeredProperties);
        propertySheet.propValues = new HashMap<String, Object>(this.propValues);
        propertySheet.rawProps = new HashMap<String, Object>(this.rawProps);
        for (String string : propertySheet.getRegisteredProperties()) {
            if (this.getType(string) != PropertyType.COMPONENT_LIST) continue;
            propertySheet.rawProps.put(string, ConfigurationManagerUtils.toStringList(this.rawProps.get(string)));
            propertySheet.propValues.put(string, null);
        }
        propertySheet.cm = this.cm;
        propertySheet.owner = null;
        propertySheet.instanceName = this.instanceName;
        return propertySheet;
    }

    public boolean validate() {
        for (String string : this.rawProps.keySet()) {
            if (string.equals(COMP_LOG_LEVEL) || this.registeredProperties.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    private static Map<Field, Annotation> parseClass(Class<? extends Configurable> clazz) {
        Field[] fieldArray = clazz.getFields();
        HashMap<Field, Annotation> hashMap = new HashMap<Field, Annotation>();
        for (Field field : fieldArray) {
            Annotation[] annotationArray;
            for (Annotation annotation : annotationArray = field.getAnnotations()) {
                Annotation[] annotationArray2;
                for (Annotation annotation2 : annotationArray2 = annotation.annotationType().getAnnotations()) {
                    if (!(annotation2 instanceof S4Property)) continue;
                    int n = field.getModifiers();
                    assert (Modifier.isStatic(n)) : "property fields are assumed to be static";
                    assert (Modifier.isPublic(n)) : "property fields are assumed to be public";
                    assert (Modifier.isFinal(n)) : "property fields are assumed to be final";
                    assert (field.getType().equals(String.class)) : "properties fields are assumed to be instances of java.lang.String";
                    hashMap.put(field, annotation);
                }
            }
        }
        return hashMap;
    }
}

