/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props;

import java.net.URL;
import java.util.List;

public enum PropertyType {
    INT("int"){

        @Override
        protected boolean validateString(String string) throws Exception {
            Integer.parseInt(string);
            return true;
        }
    }
    ,
    BOOLEAN("boolean"){

        @Override
        protected boolean validateString(String string) throws Exception {
            return "true".equals(string = string.toLowerCase()) || "false".equals(string);
        }
    }
    ,
    FLOAT("float"){

        @Override
        protected boolean validateString(String string) throws Exception {
            Float.parseFloat(string);
            return true;
        }
    }
    ,
    DOUBLE("double"){

        @Override
        protected boolean validateString(String string) throws Exception {
            Double.parseDouble(string);
            return true;
        }
    }
    ,
    COMPONENT("Component", String.class),
    COMPONENT_LIST("ComponentList", List.class),
    STRING("String", String.class),
    RESOURCE("Resource"){

        @Override
        public boolean validateString(String string) throws Exception {
            if (string.toLowerCase().startsWith("resource:/")) {
                return true;
            }
            if (string.indexOf(58) == -1) {
                string = "file:" + string;
            }
            new URL(string);
            return true;
        }
    }
    ,
    STRING_LIST("StringList", List.class);

    private final String displayName;
    private Class<?> checkClass;

    private PropertyType(String string2) {
        this.displayName = string2;
    }

    private PropertyType(String string2, Class<?> clazz) {
        this.displayName = string2;
        this.checkClass = clazz;
    }

    public String toString() {
        return this.displayName;
    }

    protected boolean validateString(String string) throws Exception {
        return true;
    }

    public boolean isValid(Object object) {
        if (this.checkClass != null) {
            return this.checkClass.isInstance(object);
        }
        if (object instanceof String) {
            try {
                return this.validateString((String)object);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }
}

