/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props;

import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.ConfigurationManagerUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RawPropertyData {
    private String name;
    private String className;
    private Map<String, Object> properties;

    public RawPropertyData(String string, String string2) {
        this(string, string2, new HashMap<String, Object>());
    }

    public RawPropertyData(String string, String string2, Map<String, Object> map) {
        this.name = string;
        this.className = string2;
        this.properties = map;
    }

    public void add(String string, String string2) {
        this.properties.put(string, string2);
    }

    public void add(String string, List<String> list) {
        this.properties.put(string, list);
    }

    public void remove(String string) {
        this.properties.remove(string);
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean contains(String string) {
        return this.properties.get(string) != null;
    }

    public RawPropertyData flatten(ConfigurationManager configurationManager) {
        RawPropertyData rawPropertyData = new RawPropertyData(this.name, this.className);
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof String && ((String)object).startsWith("${")) {
                object = configurationManager.getGloPropReference(ConfigurationManagerUtils.stripGlobalSymbol((String)object));
            }
            rawPropertyData.properties.put(entry.getKey(), object);
        }
        return rawPropertyData;
    }

    public String getGlobalProperty(String string, Map<String, String> map) {
        if (!string.startsWith("${")) {
            return string;
        }
        while ((string = map.get(string)) != null && string.startsWith("${") && string.endsWith("}")) {
        }
        return string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("name : ").append(this.name);
        for (Object object : this.properties.values()) {
            if (object == null) continue;
            if (object instanceof String) {
                stringBuilder.append("value string : ");
            }
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }
}

