/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props;

import edu.cmu.sphinx.util.props.ConfigHandler;
import edu.cmu.sphinx.util.props.RawPropertyData;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SaxLoader {
    private final URL url;
    private final Map<String, RawPropertyData> rpdMap;
    private final Map<String, String> globalProperties;
    private final boolean replaceDuplicates;

    public SaxLoader(URL uRL, Map<String, String> map, Map<String, RawPropertyData> hashMap, boolean bl) {
        this.url = uRL;
        this.globalProperties = map;
        this.replaceDuplicates = bl;
        this.rpdMap = hashMap == null ? new HashMap() : hashMap;
    }

    public SaxLoader(URL uRL, Map<String, String> map) {
        this(uRL, map, null, false);
    }

    public Map<String, RawPropertyData> load() throws IOException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            ConfigHandler configHandler = new ConfigHandler(this.rpdMap, this.globalProperties, this.replaceDuplicates, this.url);
            xMLReader.setContentHandler(configHandler);
            xMLReader.parse(this.url.toString());
        }
        catch (SAXParseException sAXParseException) {
            String string = "Error while parsing line " + sAXParseException.getLineNumber() + " of " + this.url + ": " + sAXParseException.getMessage();
            throw new IOException(string);
        }
        catch (SAXException sAXException) {
            throw new IOException("Problem with XML: " + sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getMessage());
        }
        return this.rpdMap;
    }
}

