/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props.tools;

import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.PropertyType;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;

public class GDLDumper {
    public static void dumpComponentAsGDL(ConfigurationManager configurationManager, PrintStream printStream, String string) {
        printStream.println("node: {title: \"" + string + "\" color: " + GDLDumper.getColor(configurationManager, string) + '}');
        PropertySheet propertySheet = configurationManager.getPropertySheet(string);
        Collection<String> collection = propertySheet.getRegisteredProperties();
        for (String string2 : collection) {
            PropertyType propertyType = propertySheet.getType(string2);
            Object object = propertySheet.getRaw(string2);
            if (object == null) continue;
            if (propertyType == PropertyType.COMPONENT) {
                printStream.println("edge: {source: \"" + string + "\" target: \"" + object + "\"}");
                continue;
            }
            if (propertyType != PropertyType.COMPONENT_LIST) continue;
            List list = (List)object;
            for (Object e : list) {
                printStream.println("edge: {source: \"" + string + "\" target: \"" + e + "\"}");
            }
        }
    }

    public static void showConfigAsGDL(ConfigurationManager configurationManager, String string) throws IOException {
        PrintStream printStream = new PrintStream(new FileOutputStream(string));
        GDLDumper.dumpGDLHeader(printStream);
        for (String string2 : configurationManager.getInstanceNames(Configurable.class)) {
            GDLDumper.dumpComponentAsGDL(configurationManager, printStream, string2);
        }
        GDLDumper.dumpGDLFooter(printStream);
        printStream.close();
    }

    public static void dumpGDLHeader(PrintStream printStream) {
        printStream.println(" graph: {title: \"unix evolution\" ");
        printStream.println("         layoutalgorithm: tree");
        printStream.println("          scaling        : 2.0");
        printStream.println("          colorentry 42  : 152 222 255");
        printStream.println("     node.shape     : ellipse");
        printStream.println("      node.color     : 42 ");
        printStream.println("node.height    : 32  ");
        printStream.println("node.fontname  : \"helvB08\"");
        printStream.println("edge.color     : darkred");
        printStream.println("edge.arrowsize :  6    ");
        printStream.println("node.textcolor : darkblue ");
        printStream.println("splines        : yes");
    }

    public static String getColor(ConfigurationManager configurationManager, String string) {
        try {
            Object c = configurationManager.lookup(string);
            Class<?> clazz = c.getClass();
            if (clazz.getName().indexOf(".recognizer") > 1) {
                return "cyan";
            }
            if (clazz.getName().indexOf(".tools") > 1) {
                return "darkcyan";
            }
            if (clazz.getName().indexOf(".decoder") > 1) {
                return "green";
            }
            if (clazz.getName().indexOf(".frontend") > 1) {
                return "orange";
            }
            if (clazz.getName().indexOf(".acoustic") > 1) {
                return "turquoise";
            }
            if (clazz.getName().indexOf(".linguist") > 1) {
                return "lightblue";
            }
            if (clazz.getName().indexOf(".instrumentation") > 1) {
                return "lightgrey";
            }
            if (clazz.getName().indexOf(".util") > 1) {
                return "lightgrey";
            }
        }
        catch (PropertyException propertyException) {
            return "black";
        }
        return "darkgrey";
    }

    public static void dumpGDLFooter(PrintStream printStream) {
        printStream.println("}");
    }
}

