/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props.tools;

import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.PropertySheet;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;

public class HTMLDumper {
    public static void showConfigAsHTML(ConfigurationManager configurationManager, String string) throws IOException {
        PrintStream printStream = new PrintStream(new FileOutputStream(string));
        HTMLDumper.dumpHeader(printStream);
        for (String string2 : configurationManager.getInstanceNames(Configurable.class)) {
            HTMLDumper.dumpComponentAsHTML(printStream, string2, configurationManager.getPropertySheet(string2));
        }
        HTMLDumper.dumpFooter(printStream);
        printStream.close();
    }

    public static void dumpFooter(PrintStream printStream) {
        printStream.println("</body>");
        printStream.println("</html>");
    }

    public static void dumpHeader(PrintStream printStream) {
        printStream.println("<html><head>");
        printStream.println("    <title> Sphinx-4 Configuration</title");
        printStream.println("</head>");
        printStream.println("<body>");
    }

    public static void dumpComponentAsHTML(PrintStream printStream, String string, PropertySheet propertySheet) {
        printStream.println("<table border=1>");
        printStream.print("    <tr><th bgcolor=\"#CCCCFF\" colspan=2>");
        printStream.print(string);
        printStream.print("</a>");
        printStream.println("</td></tr>");
        printStream.println("    <tr><th bgcolor=\"#CCCCFF\">Property</th><th bgcolor=\"#CCCCFF\"> Value</th></tr>");
        Collection<String> collection = propertySheet.getRegisteredProperties();
        for (String string2 : collection) {
            printStream.print("    <tr><th align=\"leftt\">" + string2 + "</th>");
            Object object = propertySheet.getRaw(string2);
            if (object instanceof String) {
                printStream.println("<td>" + object + "</td></tr>");
                continue;
            }
            if (object instanceof List) {
                List list = (List)object;
                printStream.println("    <td><ul>");
                for (Object e : list) {
                    printStream.println("        <li>" + e + "</li>");
                }
                printStream.println("    </ul></td>");
                continue;
            }
            printStream.println("<td>DEFAULT</td></tr>");
        }
        printStream.println("</table><br>");
    }
}

