/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.command.ActivateJobsCommandStep1;
import io.camunda.zeebe.client.api.command.CancelProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.DeployProcessCommandStep1;
import io.camunda.zeebe.client.api.command.FailJobCommandStep1;
import io.camunda.zeebe.client.api.command.PublishMessageCommandStep1;
import io.camunda.zeebe.client.api.command.ResolveIncidentCommandStep1;
import io.camunda.zeebe.client.api.command.SetVariablesCommandStep1;
import io.camunda.zeebe.client.api.command.ThrowErrorCommandStep1;
import io.camunda.zeebe.client.api.command.TopologyRequestStep1;
import io.camunda.zeebe.client.api.command.UpdateRetriesJobCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.camunda.zeebe.spring.client.ZeebeClientObjectFactory;
import io.camunda.zeebe.spring.client.event.ClientStartedEvent;
import io.camunda.zeebe.spring.util.ZeebeAutoStartUpLifecycle;
import io.camunda.zeebe.spring.util.ZeebeObjectFactory;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.context.ApplicationEventPublisher;

public class ZeebeClientLifecycle
extends ZeebeAutoStartUpLifecycle<ZeebeClient>
implements ZeebeClient {
    public static final int PHASE = 22222;
    private final ApplicationEventPublisher publisher;
    private final Set<Consumer<ZeebeClient>> startListener = new LinkedHashSet<Consumer<ZeebeClient>>();

    public ZeebeClientLifecycle(ZeebeClientObjectFactory factory, ApplicationEventPublisher publisher) {
        super(22222, (ZeebeObjectFactory)factory);
        this.publisher = publisher;
    }

    public ZeebeClientLifecycle addStartListener(Consumer<ZeebeClient> consumer) {
        this.startListener.add(consumer);
        if (this.isRunning()) {
            consumer.accept(this);
        }
        return this;
    }

    public void start() {
        super.start();
        this.publisher.publishEvent((Object)new ClientStartedEvent());
        this.startListener.forEach(c -> c.accept(this));
    }

    public ZeebeClientConfiguration getConfiguration() {
        return ((ZeebeClient)this.get()).getConfiguration();
    }

    public void close() {
        this.stop();
    }

    public TopologyRequestStep1 newTopologyRequest() {
        return ((ZeebeClient)this.get()).newTopologyRequest();
    }

    public DeployProcessCommandStep1 newDeployCommand() {
        return ((ZeebeClient)this.get()).newDeployCommand();
    }

    public CreateProcessInstanceCommandStep1 newCreateInstanceCommand() {
        return ((ZeebeClient)this.get()).newCreateInstanceCommand();
    }

    public CancelProcessInstanceCommandStep1 newCancelInstanceCommand(long workflowInstanceKey) {
        return ((ZeebeClient)this.get()).newCancelInstanceCommand(workflowInstanceKey);
    }

    public SetVariablesCommandStep1 newSetVariablesCommand(long elementInstanceKey) {
        return ((ZeebeClient)this.get()).newSetVariablesCommand(elementInstanceKey);
    }

    public PublishMessageCommandStep1 newPublishMessageCommand() {
        return ((ZeebeClient)this.get()).newPublishMessageCommand();
    }

    public ResolveIncidentCommandStep1 newResolveIncidentCommand(long incidentKey) {
        return ((ZeebeClient)this.get()).newResolveIncidentCommand(incidentKey);
    }

    public UpdateRetriesJobCommandStep1 newUpdateRetriesCommand(long jobKey) {
        return ((ZeebeClient)this.get()).newUpdateRetriesCommand(jobKey);
    }

    public UpdateRetriesJobCommandStep1 newUpdateRetriesCommand(ActivatedJob job) {
        return this.newUpdateRetriesCommand(job.getKey());
    }

    public JobWorkerBuilderStep1 newWorker() {
        return ((ZeebeClient)this.get()).newWorker();
    }

    public ActivateJobsCommandStep1 newActivateJobsCommand() {
        return ((ZeebeClient)this.get()).newActivateJobsCommand();
    }

    public CompleteJobCommandStep1 newCompleteCommand(long jobKey) {
        return ((ZeebeClient)this.get()).newCompleteCommand(jobKey);
    }

    public CompleteJobCommandStep1 newCompleteCommand(ActivatedJob job) {
        return this.newCompleteCommand(job.getKey());
    }

    public FailJobCommandStep1 newFailCommand(long jobKey) {
        return ((ZeebeClient)this.get()).newFailCommand(jobKey);
    }

    public FailJobCommandStep1 newFailCommand(ActivatedJob job) {
        return this.newFailCommand(job.getKey());
    }

    public ThrowErrorCommandStep1 newThrowErrorCommand(long jobKey) {
        return ((ZeebeClient)this.get()).newThrowErrorCommand(jobKey);
    }

    public ThrowErrorCommandStep1 newThrowErrorCommand(ActivatedJob job) {
        return this.newThrowErrorCommand(job.getKey());
    }
}

