/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.config.processor;

import io.camunda.zeebe.spring.client.ZeebeClientLifecycle;
import io.camunda.zeebe.spring.client.bean.ClassInfo;
import io.camunda.zeebe.spring.client.config.processor.BeanInfoPostProcessor;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class SubscriptionBuilderPostProcessor
implements BeanPostProcessor,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<BeanInfoPostProcessor> processors;
    private final ZeebeClientLifecycle clientLifecycle;

    public SubscriptionBuilderPostProcessor(List<BeanInfoPostProcessor> processors, ZeebeClientLifecycle clientLifecycle) {
        this.processors = processors;
        this.clientLifecycle = clientLifecycle;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        ClassInfo beanInfo = ClassInfo.builder().bean(bean).beanName(beanName).build();
        for (BeanInfoPostProcessor p : this.processors) {
            if (!p.test(beanInfo)) continue;
            Consumer c = (Consumer)p.apply(beanInfo);
            this.clientLifecycle.addStartListener(c);
        }
        return bean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

