/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.config.processor;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.camunda.zeebe.spring.client.annotation.ZeebeWorker;
import io.camunda.zeebe.spring.client.bean.ClassInfo;
import io.camunda.zeebe.spring.client.bean.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.bean.value.factory.ReadZeebeWorkerValue;
import io.camunda.zeebe.spring.client.config.processor.BeanInfoPostProcessor;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.JobHandlerInvokingSpringBeans;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ZeebeWorkerPostProcessor
extends BeanInfoPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ReadZeebeWorkerValue reader;
    private final DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final BackoffSupplier backoffSupplier;

    public ZeebeWorkerPostProcessor(ReadZeebeWorkerValue reader, DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy, BackoffSupplier backoffSupplier) {
        this.reader = reader;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.backoffSupplier = backoffSupplier;
    }

    @Override
    public boolean test(ClassInfo beanInfo) {
        return beanInfo.hasMethodAnnotation(ZeebeWorker.class);
    }

    @Override
    public Consumer<ZeebeClient> apply(ClassInfo beanInfo) {
        LOGGER.info("Registering Zeebe worker(s) of bean: {}", beanInfo.getBean());
        ArrayList annotatedMethods = new ArrayList();
        ReflectionUtils.doWithMethods(beanInfo.getTargetClass(), method -> this.reader.apply(beanInfo.toMethodInfo(method)).ifPresent(annotatedMethods::add), (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        return client -> annotatedMethods.forEach(zeebeWorkerValue -> {
            JobWorkerBuilderStep1.JobWorkerBuilderStep3 builder = client.newWorker().jobType(zeebeWorkerValue.getType()).handler((JobHandler)new JobHandlerInvokingSpringBeans((ZeebeWorkerValue)zeebeWorkerValue, this.commandExceptionHandlingStrategy));
            if (zeebeWorkerValue.getName() != null && zeebeWorkerValue.getName().length() > 0) {
                builder.name(zeebeWorkerValue.getName());
            } else {
                builder.name(beanInfo.getBeanName() + "#" + zeebeWorkerValue.getMethodInfo().getMethodName());
            }
            if (zeebeWorkerValue.getMaxJobsActive() > 0) {
                builder.maxJobsActive(zeebeWorkerValue.getMaxJobsActive());
            }
            if (zeebeWorkerValue.getTimeout() > 0L) {
                builder.timeout(zeebeWorkerValue.getTimeout());
            }
            if (zeebeWorkerValue.getPollInterval() > 0L) {
                builder.pollInterval(Duration.ofMillis(zeebeWorkerValue.getPollInterval()));
            }
            if (zeebeWorkerValue.getRequestTimeout() > 0L) {
                builder.requestTimeout(Duration.ofSeconds(zeebeWorkerValue.getRequestTimeout()));
            }
            if (zeebeWorkerValue.getFetchVariables().length > 0) {
                builder.fetchVariables(zeebeWorkerValue.getFetchVariables());
            }
            builder.open();
            LOGGER.info(". Register Zeebe worker: {}", zeebeWorkerValue);
        });
    }
}

