/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.jobhandling;

import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.ThrowErrorCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.impl.Loggers;
import io.camunda.zeebe.spring.client.annotation.ZeebeCustomHeaders;
import io.camunda.zeebe.spring.client.annotation.ZeebeVariable;
import io.camunda.zeebe.spring.client.annotation.ZeebeVariablesAsType;
import io.camunda.zeebe.spring.client.bean.ParameterInfo;
import io.camunda.zeebe.spring.client.bean.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.exception.ZeebeBpmnError;
import io.camunda.zeebe.spring.client.jobhandling.CommandWrapper;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class JobHandlerInvokingSpringBeans
implements JobHandler {
    private static final Logger LOG = Loggers.JOB_WORKER_LOGGER;
    private ZeebeWorkerValue workerValue;
    private DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy;

    public JobHandlerInvokingSpringBeans(ZeebeWorkerValue workerValue, DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy) {
        this.workerValue = workerValue;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
    }

    public void handle(JobClient jobClient, ActivatedJob job) throws Exception {
        List<Object> args = this.createParameters(jobClient, job, this.workerValue.getMethodInfo().getParameters());
        try {
            Object result = this.workerValue.getMethodInfo().invoke(args.toArray());
            if (this.workerValue.isAutoComplete()) {
                CommandWrapper command = new CommandWrapper((FinalCommandStep<Void>)this.createCompleteCommand(jobClient, job, result), job, this.commandExceptionHandlingStrategy);
                command.executeAsync();
            }
        }
        catch (ZeebeBpmnError bpmnError) {
            CommandWrapper command = new CommandWrapper(this.createThrowErrorCommand(jobClient, job, bpmnError), job, this.commandExceptionHandlingStrategy);
            command.executeAsync();
        }
    }

    private List<Object> createParameters(JobClient jobClient, ActivatedJob job, List<ParameterInfo> parameters) {
        ArrayList<Object> args = new ArrayList<Object>();
        for (ParameterInfo param : parameters) {
            Object arg = null;
            Class<?> clazz = param.getParameterInfo().getType();
            if (JobClient.class.isAssignableFrom(clazz)) {
                arg = jobClient;
            } else if (ActivatedJob.class.isAssignableFrom(clazz)) {
                arg = job;
            } else {
                if (param.getParameterInfo().isAnnotationPresent(ZeebeVariable.class)) {
                    try {
                        arg = clazz.cast(job.getVariablesAsMap().get(param.getParameterName()));
                    }
                    catch (ClassCastException ex) {
                        throw new RuntimeException("Cannot assign process variable '" + param.getParameterName() + "' to parameter, invalid type found: " + ex.getMessage());
                    }
                }
                if (param.getParameterInfo().isAnnotationPresent(ZeebeVariablesAsType.class)) {
                    try {
                        arg = job.getVariablesAsType(clazz);
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException("Cannot assign process variables to type '" + clazz.getName() + "', cause is: " + e.getMessage(), e);
                    }
                }
                if (param.getParameterInfo().isAnnotationPresent(ZeebeCustomHeaders.class)) {
                    try {
                        arg = job.getCustomHeaders();
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException("Cannot assign headers '" + param.getParameterName() + "' to parameter, cause is: " + e.getMessage(), e);
                    }
                }
            }
            args.add(arg);
        }
        return args;
    }

    public FinalCommandStep createCompleteCommand(JobClient jobClient, ActivatedJob job, Object result) {
        CompleteJobCommandStep1 completeCommand = jobClient.newCompleteCommand(job.getKey());
        if (result != null) {
            completeCommand = result.getClass().isAssignableFrom(Map.class) ? completeCommand.variables((Map)result) : (result.getClass().isAssignableFrom(String.class) ? completeCommand.variables((String)result) : (result.getClass().isAssignableFrom(InputStream.class) ? completeCommand.variables((InputStream)result) : completeCommand.variables(result)));
        }
        return completeCommand;
    }

    private FinalCommandStep<Void> createThrowErrorCommand(JobClient jobClient, ActivatedJob job, ZeebeBpmnError bpmnError) {
        ThrowErrorCommandStep1.ThrowErrorCommandStep2 command = jobClient.newThrowErrorCommand(job.getKey()).errorCode(bpmnError.getErrorCode()).errorMessage(bpmnError.getErrorMessage());
        return command;
    }
}

