/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PartitionMetadata {
    private final PartitionId id;
    private final List<MemberId> members;
    private final Map<MemberId, Integer> priority;
    private final int targetPriority;

    public PartitionMetadata(PartitionId id, List<MemberId> members, Map<MemberId, Integer> priority, int targetPriority) {
        this.id = id;
        this.members = members;
        this.priority = priority;
        this.targetPriority = targetPriority;
    }

    public PartitionId id() {
        return this.id;
    }

    public Collection<MemberId> members() {
        return this.members;
    }

    public int getPriority(MemberId member) {
        return this.priority.getOrDefault(member, -1);
    }

    public int getTargetPriority() {
        return this.targetPriority;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.members);
    }

    public boolean equals(Object object) {
        if (object instanceof PartitionMetadata) {
            PartitionMetadata partition = (PartitionMetadata)object;
            return partition.id.equals(this.id) && partition.members.equals(this.members);
        }
        return false;
    }

    public String toString() {
        return "PartitionMetadata{id=" + this.id + ", members=" + this.members + ", priority=" + this.priority + ", targetPriority=" + this.targetPriority + "}";
    }
}

