/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.raft.RaftRoleChangeListener;
import io.atomix.raft.RaftServer;
import io.atomix.raft.RaftThreadContextFactory;
import io.atomix.raft.cluster.RaftCluster;
import io.atomix.raft.impl.DefaultRaftSingleThreadContextFactory;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.storage.RaftStorage;
import io.atomix.utils.concurrent.AtomixFuture;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.camunda.zeebe.util.health.FailureListener;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class DefaultRaftServer
implements RaftServer {
    protected final RaftContext context;
    private final Logger log;
    private final AtomicReference<CompletableFuture<RaftServer>> openFutureRef = new AtomicReference();
    private volatile boolean started;
    private volatile boolean stopped = false;

    public DefaultRaftServer(RaftContext context) {
        this.context = (RaftContext)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftServer.class).addValue((Object)context.getName()).build());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name()).toString();
    }

    @Override
    public String name() {
        return this.context.getName();
    }

    @Override
    public RaftCluster cluster() {
        return this.context.getCluster();
    }

    @Override
    public void addRoleChangeListener(RaftRoleChangeListener listener) {
        this.context.addRoleChangeListener(listener);
    }

    @Override
    public void removeRoleChangeListener(RaftRoleChangeListener listener) {
        this.context.removeRoleChangeListener(listener);
    }

    @Override
    public void addFailureListener(FailureListener listener) {
        this.context.addFailureListener(listener);
    }

    @Override
    public void removeFailureListener(FailureListener listener) {
        this.context.removeFailureListener(listener);
    }

    @Override
    public CompletableFuture<RaftServer> bootstrap(Collection<MemberId> cluster) {
        return this.start(() -> this.cluster().bootstrap(cluster));
    }

    @Override
    public CompletableFuture<RaftServer> promote() {
        return this.context.anoint().thenApply(v -> this);
    }

    @Override
    public CompletableFuture<Void> compact() {
        return this.context.compact();
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        if (!this.started && !this.stopped) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("Server not running"));
        }
        if (this.stopped) {
            return Futures.completedFuture(null);
        }
        AtomixFuture future = new AtomixFuture();
        this.context.getThreadContext().execute(() -> this.lambda$shutdown$2((CompletableFuture)future));
        return future;
    }

    @Override
    public CompletableFuture<Void> goInactive() {
        AtomixFuture future = new AtomixFuture();
        this.context.getThreadContext().execute(() -> this.lambda$goInactive$3((CompletableFuture)future));
        return future;
    }

    @Override
    public RaftContext getContext() {
        return this.context;
    }

    @Override
    public long getTerm() {
        return this.context.getTerm();
    }

    @Override
    public RaftServer.Role getRole() {
        return this.context.getRole();
    }

    @Override
    public boolean isRunning() {
        return this.started && !this.stopped && this.context.isRunning();
    }

    @Override
    public CompletableFuture<Void> stepDown() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.context.getThreadContext().execute(() -> {
            this.context.transition(RaftServer.Role.FOLLOWER);
            future.complete(null);
        });
        return future;
    }

    private CompletableFuture<RaftServer> start(Supplier<CompletableFuture<Void>> joiner) {
        if (this.started) {
            return CompletableFuture.completedFuture(this);
        }
        if (this.openFutureRef.compareAndSet(null, (CompletableFuture<RaftServer>)new AtomixFuture())) {
            this.stopped = false;
            joiner.get().whenComplete((result, error) -> {
                if (error == null) {
                    this.log.info("Server join completed. Waiting for the server to be READY");
                    this.context.awaitState(RaftContext.State.READY, state -> {
                        this.started = true;
                        this.openFutureRef.get().complete(this);
                    });
                } else {
                    this.openFutureRef.get().completeExceptionally((Throwable)error);
                }
            });
        }
        return this.openFutureRef.get().whenComplete((result, error) -> {
            if (error == null) {
                this.log.debug("Server started successfully!");
            } else {
                this.log.warn("Failed to start server!");
            }
        });
    }

    private /* synthetic */ void lambda$goInactive$3(CompletableFuture future) {
        this.context.transition(RaftServer.Role.INACTIVE);
        future.complete(null);
    }

    private /* synthetic */ void lambda$shutdown$2(CompletableFuture future) {
        this.stopped = true;
        this.started = false;
        this.context.transition(RaftServer.Role.INACTIVE);
        this.context.close();
        future.complete(null);
    }

    public static class Builder
    extends RaftServer.Builder {
        public Builder(MemberId localMemberId) {
            super(localMemberId);
        }

        public RaftServer build() {
            if (this.name == null) {
                this.name = (String)((Object)this.localMemberId.id());
            }
            if (this.storage == null) {
                this.storage = RaftStorage.builder().build();
            }
            RaftThreadContextFactory singleThreadFactory = this.threadContextFactory == null ? new DefaultRaftSingleThreadContextFactory() : this.threadContextFactory;
            Supplier randomSupplier = this.randomFactory == null ? Random::new : this.randomFactory;
            RaftContext raft = new RaftContext(this.name, this.partitionId, this.localMemberId, this.membershipService, this.protocol, this.storage, singleThreadFactory, randomSupplier, this.electionConfig, this.partitionConfig);
            raft.setEntryValidator(this.entryValidator);
            return new DefaultRaftServer(raft);
        }
    }
}

