/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftMetrics;
import io.prometheus.client.Gauge;

public class RaftStartupMetrics
extends RaftMetrics {
    private static final String NAMESPACE = "atomix";
    private static final String PARTITION_GROUP_NAME_LABEL = "partitionGroupName";
    private static final String PARTITION_LABEL = "partition";
    private static final Gauge START_DURATION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).labelNames(new String[]{"partitionGroupName", "partition"})).help("Time taken to start the partition server (in ms). This includes the bootstrap time.")).name("partition_server_startup_time")).register();
    private static final Gauge BOOTSTRAP_DURATION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).labelNames(new String[]{"partitionGroupName", "partition"})).help("Time taken to bootstrap the partition server (in ms)")).name("partition_server_bootstrap_time")).register();

    public RaftStartupMetrics(String partitionName) {
        super(partitionName);
    }

    public void observeStartupDuration(long durationMillis) {
        ((Gauge.Child)START_DURATION.labels(new String[]{this.partitionGroupName, this.partition})).set((double)durationMillis);
    }

    public void observeBootstrapDuration(long durationMillis) {
        ((Gauge.Child)BOOTSTRAP_DURATION.labels(new String[]{this.partitionGroupName, this.partition})).set((double)durationMillis);
    }
}

