/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.log.RaftLogReader;
import io.atomix.raft.storage.log.RaftLogUncommittedReader;
import io.atomix.raft.storage.serializer.RaftEntrySBESerializer;
import io.atomix.raft.storage.serializer.RaftEntrySerializer;
import java.util.NoSuchElementException;

public class RaftLogCommittedReader
implements RaftLogReader {
    private final RaftLog log;
    private final RaftEntrySerializer serializer = new RaftEntrySBESerializer();
    private long nextIndex;
    private final RaftLogUncommittedReader reader;

    RaftLogCommittedReader(RaftLog log, RaftLogUncommittedReader reader) {
        this.log = log;
        this.reader = reader;
        this.nextIndex = log.getFirstIndex();
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex <= this.log.getCommitIndex() && this.reader.hasNext();
    }

    @Override
    public IndexedRaftLogEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        IndexedRaftLogEntry entry = this.reader.next();
        this.nextIndex = entry.index() + 1L;
        return entry;
    }

    @Override
    public long reset() {
        this.nextIndex = this.reader.reset();
        return this.nextIndex;
    }

    @Override
    public long seek(long index) {
        long upperBoundIndex = this.log.getCommitIndex() + 1L;
        long boundIndex = Math.min(index, upperBoundIndex);
        this.nextIndex = this.reader.seek(boundIndex);
        return this.nextIndex;
    }

    @Override
    public long seekToLast() {
        this.seek(this.log.getCommitIndex());
        return this.nextIndex;
    }

    @Override
    public long seekToAsqn(long asqn) {
        this.nextIndex = this.reader.seekToAsqn(asqn, this.log.getCommitIndex());
        return this.nextIndex;
    }

    @Override
    public void close() {
        this.reader.close();
    }
}

