/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.traversal;

import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.impl.BpmnModelInstanceImpl;
import io.camunda.zeebe.model.bpmn.instance.BpmnModelElementInstance;
import io.camunda.zeebe.model.bpmn.instance.Definitions;
import io.camunda.zeebe.model.bpmn.traversal.ModelElementVisitor;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import org.camunda.bpm.model.xml.impl.ModelInstanceImpl;
import org.camunda.bpm.model.xml.impl.util.ModelUtil;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class ModelWalker {
    private final BpmnModelInstanceImpl modelInstance;
    private final Deque<BpmnModelElementInstance> elementsToVisit = new LinkedList<BpmnModelElementInstance>();

    public ModelWalker(BpmnModelInstance modelInstance) {
        this.modelInstance = (BpmnModelInstanceImpl)modelInstance;
    }

    public void walk(ModelElementVisitor visitor) {
        BpmnModelElementInstance currentElement;
        Definitions rootElement = this.modelInstance.getDefinitions();
        this.elementsToVisit.add(rootElement);
        while ((currentElement = this.elementsToVisit.poll()) != null) {
            visitor.visit(currentElement);
            Collection<ModelElementInstance> children = this.getChildElements(currentElement);
            children.forEach(c -> {
                try {
                    this.elementsToVisit.addFirst((BpmnModelElementInstance)c);
                }
                catch (ClassCastException e) {
                    throw new RuntimeException("Unable to process unknown element with name " + c.getDomElement().getLocalName(), e);
                }
            });
        }
    }

    private Collection<ModelElementInstance> getChildElements(BpmnModelElementInstance element) {
        return ModelUtil.getModelElementCollection((Collection)element.getDomElement().getChildElements(), (ModelInstanceImpl)this.modelInstance);
    }
}

