/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.el.impl.feel;

import io.camunda.zeebe.el.impl.Loggers;
import io.camunda.zeebe.el.impl.feel.MessagePackContext;
import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackToken;
import io.camunda.zeebe.msgpack.spec.MsgPackType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.Serializable;
import org.agrona.DirectBuffer;
import org.camunda.feel.context.Context;
import org.camunda.feel.syntaxtree.Val;
import org.camunda.feel.syntaxtree.ValBoolean;
import org.camunda.feel.syntaxtree.ValContext;
import org.camunda.feel.syntaxtree.ValList;
import org.camunda.feel.syntaxtree.ValNull$;
import org.camunda.feel.syntaxtree.ValNumber;
import org.camunda.feel.syntaxtree.ValString;
import org.camunda.feel.valuemapper.CustomValueMapper;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.math.BigDecimal$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005-4A!\u0003\u0006\u0001/!)\u0001\u0006\u0001C\u0001S!9A\u0006\u0001b\u0001\n\u0013i\u0003B\u0002\u001c\u0001A\u0003%a\u0006C\u00038\u0001\u0011\u0005\u0003\bC\u0003M\u0001\u0011%Q\nC\u0003W\u0001\u0011%q\u000bC\u0003Y\u0001\u0011%\u0011\fC\u0003e\u0001\u0011\u0005SM\u0001\fNKN\u001c\u0018mZ3QC\u000e\\g+\u00197vK6\u000b\u0007\u000f]3s\u0015\tYA\"\u0001\u0003gK\u0016d'BA\u0007\u000f\u0003\u0011IW\u000e\u001d7\u000b\u0005=\u0001\u0012AA3m\u0015\t\t\"#A\u0003{K\u0016\u0014WM\u0003\u0002\u0014)\u000591-Y7v]\u0012\f'\"A\u000b\u0002\u0005%|7\u0001A\n\u0004\u0001aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002 M5\t\u0001E\u0003\u0002\"E\u0005Ya/\u00197vK6\f\u0007\u000f]3s\u0015\tY1E\u0003\u0002\u0014I)\tQ%A\u0002pe\u001eL!a\n\u0011\u0003#\r+8\u000f^8n-\u0006dW/Z'baB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u00111\u0006A\u0007\u0002\u0015\u00051!/Z1eKJ,\u0012A\f\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nAa\u001d9fG*\u00111\u0007E\u0001\b[N<\u0007/Y2l\u0013\t)\u0004GA\u0007Ng\u001e\u0004\u0016mY6SK\u0006$WM]\u0001\be\u0016\fG-\u001a:!\u0003\u0015!xNV1m)\rI$i\u0012\t\u00043ib\u0014BA\u001e\u001b\u0005\u0019y\u0005\u000f^5p]B\u0011Q\bQ\u0007\u0002})\u0011qHI\u0001\u000bgftG/\u0019=ue\u0016,\u0017BA!?\u0005\r1\u0016\r\u001c\u0005\u0006\u0007\u0012\u0001\r\u0001R\u0001\u0002qB\u0011\u0011$R\u0005\u0003\rj\u00111!\u00118z\u0011\u0015AE\u00011\u0001J\u0003AIgN\\3s-\u0006dW/Z'baB,'\u000f\u0005\u0003\u001a\u0015\u0012c\u0014BA&\u001b\u0005%1UO\\2uS>t\u0017'A\bsK\u0006$W*Z:tC\u001e,\u0007+Y2l)\tad\nC\u0003P\u000b\u0001\u0007\u0001+A\u0006nKN\u001c\u0018mZ3QC\u000e\\\u0007CA)U\u001b\u0005\u0011&BA*%\u0003\u0019\twM]8oC&\u0011QK\u0015\u0002\r\t&\u0014Xm\u0019;Ck\u001a4WM]\u0001\te\u0016\fGMT3yiR\tA(\u0001\u0003sK\u0006$Gc\u0001\u001f[?\")1l\u0002a\u00019\u0006)Ao\\6f]B\u0011q&X\u0005\u0003=B\u0012A\"T:h!\u0006\u001c7\u000eV8lK:DQ\u0001Y\u0004A\u0002\u0005\faa\u001c4gg\u0016$\bCA\rc\u0013\t\u0019'DA\u0002J]R\f\u0011\"\u001e8qC\u000e\\g+\u00197\u0015\u0007\u0019<\u0017\u000eE\u0002\u001au\u0011CQ\u0001\u001b\u0005A\u0002q\nQA^1mk\u0016DQ\u0001\u0013\u0005A\u0002)\u0004B!\u0007&=\t\u0002")
public class MessagePackValueMapper
implements CustomValueMapper {
    private final MsgPackReader reader;
    private int priority;

    public int priority() {
        return this.priority;
    }

    public void org$camunda$feel$valuemapper$CustomValueMapper$_setter_$priority_$eq(int x$1) {
        this.priority = x$1;
    }

    private MsgPackReader reader() {
        return this.reader;
    }

    public Option<Val> toVal(Object x, Function1<Object, Val> innerValueMapper) {
        None$ none$;
        Object object = x;
        if (object instanceof DirectBuffer) {
            DirectBuffer directBuffer = (DirectBuffer)object;
            Val value = this.readMessagePack(directBuffer);
            none$ = new Some((Object)value);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Val readMessagePack(DirectBuffer messagePack) {
        this.reader().wrap(messagePack, 0, messagePack.capacity());
        return this.readNext();
    }

    private Val readNext() {
        int offset = this.reader().getOffset();
        MsgPackToken token = this.reader().readToken();
        return this.read(token, offset);
    }

    private Val read(MsgPackToken token, int offset) {
        ValNull$ valNull$;
        MsgPackType msgPackType = token.getType();
        if (MsgPackType.NIL.equals(msgPackType)) {
            valNull$ = ValNull$.MODULE$;
        } else if (MsgPackType.BOOLEAN.equals(msgPackType)) {
            valNull$ = new ValBoolean(token.getBooleanValue());
        } else if (MsgPackType.INTEGER.equals(msgPackType)) {
            valNull$ = new ValNumber(BigDecimal$.MODULE$.long2bigDecimal(token.getIntegerValue()));
        } else if (MsgPackType.FLOAT.equals(msgPackType)) {
            valNull$ = new ValNumber(BigDecimal$.MODULE$.double2bigDecimal(token.getFloatValue()));
        } else if (MsgPackType.STRING.equals(msgPackType)) {
            String asString = BufferUtil.bufferAsString((DirectBuffer)token.getValueBuffer());
            valNull$ = new ValString(asString);
        } else if (MsgPackType.ARRAY.equals(msgPackType)) {
            List items = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), token.getSize()).map((Function1 & Serializable)x$1 -> this.readNext()).toList();
            valNull$ = new ValList(items);
        } else if (MsgPackType.MAP.equals(msgPackType)) {
            MessagePackContext context = new MessagePackContext(this.reader(), offset, token.getSize());
            valNull$ = new ValContext((Context)context);
        } else {
            Loggers.LOGGER.warn("No MessagePack to FEEL transformation for type '{}'. Using 'null' instead.", (Object)msgPackType);
            valNull$ = ValNull$.MODULE$;
        }
        return valNull$;
    }

    public Option<Object> unpackVal(Val value, Function1<Val, Object> innerValueMapper) {
        return new Some((Object)value);
    }

    public MessagePackValueMapper() {
        CustomValueMapper.$init$((CustomValueMapper)this);
        this.reader = new MsgPackReader();
        Statics.releaseFence();
    }
}

