/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.msgpack.value;

import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.msgpack.value.BaseValue;
import java.util.Objects;

public final class BooleanValue
extends BaseValue {
    private boolean val = false;

    public BooleanValue() {
        this(false);
    }

    public BooleanValue(boolean initialValue) {
        this.val = initialValue;
    }

    @Override
    public void reset() {
        this.val = false;
    }

    public boolean getValue() {
        return this.val;
    }

    public void setValue(boolean value) {
        this.val = value;
    }

    @Override
    public void writeJSON(StringBuilder builder) {
        builder.append(this.val);
    }

    @Override
    public void write(MsgPackWriter writer) {
        writer.writeBoolean(this.val);
    }

    @Override
    public void read(MsgPackReader reader) {
        this.val = reader.readBoolean();
    }

    @Override
    public int getEncodedLength() {
        return MsgPackWriter.getEncodedBooleanValueLength();
    }

    public int hashCode() {
        return Objects.hash(this.val);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BooleanValue)) {
            return false;
        }
        BooleanValue that = (BooleanValue)o;
        return this.val == that.val;
    }
}

