/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.msgpack.value;

import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.UndeclaredProperty;
import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.msgpack.value.BaseValue;
import io.camunda.zeebe.msgpack.value.StringValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ObjectValue
extends BaseValue {
    private final List<BaseProperty<? extends BaseValue>> declaredProperties = new ArrayList<BaseProperty<? extends BaseValue>>();
    private final List<UndeclaredProperty> undeclaredProperties = new ArrayList<UndeclaredProperty>();
    private final List<UndeclaredProperty> recycledProperties = new ArrayList<UndeclaredProperty>();
    private final StringValue decodedKey = new StringValue();

    public ObjectValue declareProperty(BaseProperty<? extends BaseValue> prop) {
        this.declaredProperties.add(prop);
        return this;
    }

    @Override
    public void reset() {
        int i;
        for (i = 0; i < this.declaredProperties.size(); ++i) {
            BaseProperty<? extends BaseValue> prop = this.declaredProperties.get(i);
            prop.reset();
        }
        for (i = this.undeclaredProperties.size() - 1; i >= 0; --i) {
            UndeclaredProperty undeclaredProperty = this.undeclaredProperties.remove(i);
            undeclaredProperty.reset();
            this.recycledProperties.add(undeclaredProperty);
        }
    }

    private UndeclaredProperty newUndeclaredProperty(StringValue key) {
        int recycledSize = this.recycledProperties.size();
        UndeclaredProperty prop = null;
        prop = recycledSize > 0 ? this.recycledProperties.remove(recycledSize - 1) : new UndeclaredProperty();
        prop.getKey().wrap(key);
        this.undeclaredProperties.add(prop);
        return prop;
    }

    @Override
    public void writeJSON(StringBuilder builder) {
        builder.append("{");
        this.writeJson(builder, this.declaredProperties);
        this.writeJson(builder, this.undeclaredProperties);
        builder.append("}");
    }

    @Override
    public void write(MsgPackWriter writer) {
        int size = this.declaredProperties.size() + this.undeclaredProperties.size();
        writer.writeMapHeader(size);
        this.write(writer, this.declaredProperties);
        this.write(writer, this.undeclaredProperties);
    }

    @Override
    public void read(MsgPackReader reader) {
        BaseProperty prop;
        int mapSize = reader.readMapHeader();
        for (int i = 0; i < mapSize; ++i) {
            this.decodedKey.read(reader);
            prop = null;
            for (int k = 0; k < this.declaredProperties.size(); ++k) {
                BaseProperty<? extends BaseValue> declaredProperty = this.declaredProperties.get(k);
                StringValue declaredKey = declaredProperty.getKey();
                if (!declaredKey.equals(this.decodedKey)) continue;
                prop = declaredProperty;
                break;
            }
            if (prop == null) {
                prop = this.newUndeclaredProperty(this.decodedKey);
            }
            try {
                prop.read(reader);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not read property '%s'", prop.getKey()), e);
            }
        }
        for (int p = 0; p < this.declaredProperties.size(); ++p) {
            prop = this.declaredProperties.get(p);
            if (prop.hasValue()) continue;
            throw new RuntimeException(String.format("Property '%s' has no valid value", prop.getKey()));
        }
    }

    @Override
    public int getEncodedLength() {
        int size = this.declaredProperties.size() + this.undeclaredProperties.size();
        int length = MsgPackWriter.getEncodedMapHeaderLenght((int)size);
        length += this.getEncodedLength(this.declaredProperties);
        return length += this.getEncodedLength(this.undeclaredProperties);
    }

    private <T extends BaseProperty<?>> void writeJson(StringBuilder builder, List<T> properties) {
        for (int i = 0; i < properties.size(); ++i) {
            BaseProperty prop;
            if (i > 0) {
                builder.append(",");
            }
            if (!(prop = (BaseProperty)properties.get(i)).hasValue()) continue;
            prop.writeJSON(builder);
        }
    }

    private <T extends BaseProperty<?>> void write(MsgPackWriter writer, List<T> properties) {
        for (int i = 0; i < properties.size(); ++i) {
            BaseProperty prop = (BaseProperty)properties.get(i);
            prop.write(writer);
        }
    }

    public int hashCode() {
        return Objects.hash(this.declaredProperties, this.undeclaredProperties, this.recycledProperties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectValue)) {
            return false;
        }
        ObjectValue that = (ObjectValue)o;
        return Objects.equals(this.declaredProperties, that.declaredProperties) && Objects.equals(this.undeclaredProperties, that.undeclaredProperties) && Objects.equals(this.recycledProperties, that.recycledProperties);
    }

    private <T extends BaseProperty<?>> int getEncodedLength(List<T> properties) {
        int length = 0;
        for (int i = 0; i < properties.size(); ++i) {
            BaseProperty prop = (BaseProperty)properties.get(i);
            length += prop.getEncodedLength();
        }
        return length;
    }
}

