/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.protocol.record;

import org.agrona.DirectBuffer;
import org.agrona.sbe.*;

@SuppressWarnings("all")
public final class ExecuteQueryRequestDecoder implements MessageDecoderFlyweight
{
    public static final int BLOCK_LENGTH = 11;
    public static final int TEMPLATE_ID = 30;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 3;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final ExecuteQueryRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public ExecuteQueryRequestDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public ExecuteQueryRequestDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public ExecuteQueryRequestDecoder sbeRewind()
    {
        return wrap(buffer, initialOffset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int partitionIdId()
    {
        return 1;
    }

    public static int partitionIdSinceVersion()
    {
        return 0;
    }

    public static int partitionIdEncodingOffset()
    {
        return 0;
    }

    public static int partitionIdEncodingLength()
    {
        return 2;
    }

    public static String partitionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int partitionIdNullValue()
    {
        return 65535;
    }

    public static int partitionIdMinValue()
    {
        return 0;
    }

    public static int partitionIdMaxValue()
    {
        return 65534;
    }

    public int partitionId()
    {
        return (buffer.getShort(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF);
    }


    public static int keyId()
    {
        return 2;
    }

    public static int keySinceVersion()
    {
        return 0;
    }

    public static int keyEncodingOffset()
    {
        return 2;
    }

    public static int keyEncodingLength()
    {
        return 8;
    }

    public static String keyMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long keyNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long keyMinValue()
    {
        return 0x0L;
    }

    public static long keyMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public long key()
    {
        return buffer.getLong(offset + 2, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int valueTypeId()
    {
        return 3;
    }

    public static int valueTypeSinceVersion()
    {
        return 0;
    }

    public static int valueTypeEncodingOffset()
    {
        return 10;
    }

    public static int valueTypeEncodingLength()
    {
        return 1;
    }

    public static String valueTypeMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public short valueTypeRaw()
    {
        return ((short)(buffer.getByte(offset + 10) & 0xFF));
    }

    public ValueType valueType()
    {
        return ValueType.get(((short)(buffer.getByte(offset + 10) & 0xFF)));
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final ExecuteQueryRequestDecoder decoder = new ExecuteQueryRequestDecoder();
        decoder.wrap(buffer, initialOffset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(initialOffset + actingBlockLength);
        builder.append("[ExecuteQueryRequest](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("partitionId=");
        builder.append(partitionId());
        builder.append('|');
        builder.append("key=");
        builder.append(key());
        builder.append('|');
        builder.append("valueType=");
        builder.append(valueType());

        limit(originalLimit);

        return builder;
    }
    
    public ExecuteQueryRequestDecoder sbeSkip()
    {
        sbeRewind();

        return this;
    }
}
