package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EvaluatedDecisionValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEvaluatedDecisionValue.builder()}.
 */
@Generated(from = "EvaluatedDecisionValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@ImmutableProtocol.Type(builder=ImmutableEvaluatedDecisionValue.Builder.class)
public final class ImmutableEvaluatedDecisionValue
    implements EvaluatedDecisionValue {
  private final String decisionId;
  private final String decisionName;
  private final long decisionKey;
  private final long decisionVersion;
  private final String decisionType;
  private final String decisionOutput;
  private final List<EvaluatedInputValue> evaluatedInputs;
  private final List<MatchedRuleValue> matchedRules;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableEvaluatedDecisionValue(
      String decisionId,
      String decisionName,
      long decisionKey,
      long decisionVersion,
      String decisionType,
      String decisionOutput,
      List<EvaluatedInputValue> evaluatedInputs,
      List<MatchedRuleValue> matchedRules) {
    this.decisionId = decisionId;
    this.decisionName = decisionName;
    this.decisionKey = decisionKey;
    this.decisionVersion = decisionVersion;
    this.decisionType = decisionType;
    this.decisionOutput = decisionOutput;
    this.evaluatedInputs = evaluatedInputs;
    this.matchedRules = matchedRules;
  }

  /**
   * @return the id of the evaluated decision
   */
  @Override
  public String getDecisionId() {
    return decisionId;
  }

  /**
   * @return the name of the evaluated decision
   */
  @Override
  public String getDecisionName() {
    return decisionName;
  }

  /**
   * @return the key of the evaluated decision
   */
  @Override
  public long getDecisionKey() {
    return decisionKey;
  }

  /**
   * @return the version of the evaluated decision
   */
  @Override
  public long getDecisionVersion() {
    return decisionVersion;
  }

  /**
   * @return the type of the evaluated decision
   */
  @Override
  public String getDecisionType() {
    return decisionType;
  }

  /**
   * @return the output of the evaluated decision as JSON string
   */
  @Override
  public String getDecisionOutput() {
    return decisionOutput;
  }

  /**
   * If the decision is a decision table then it returns the {@link EvaluatedInputValue evaluated
   * inputs}. The inputs are not available for other types of decision.
   * @return the evaluated inputs, or an empty list if the decision is not a decision table
   */
  @Override
  public List<EvaluatedInputValue> getEvaluatedInputs() {
    return evaluatedInputs;
  }

  /**
   * If the decision is a decision table then it returns the matched rules. The {@link
   * MatchedRuleValue matched rules} are not available for other types of decision.
   * @return the matched rules, or an empty list if the decision is not a decision table
   */
  @Override
  public List<MatchedRuleValue> getMatchedRules() {
    return matchedRules;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluatedDecisionValue#getDecisionId() decisionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluatedDecisionValue withDecisionId(String value) {
    if (Objects.equals(this.decisionId, value)) return this;
    return new ImmutableEvaluatedDecisionValue(
        value,
        this.decisionName,
        this.decisionKey,
        this.decisionVersion,
        this.decisionType,
        this.decisionOutput,
        this.evaluatedInputs,
        this.matchedRules);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluatedDecisionValue#getDecisionName() decisionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluatedDecisionValue withDecisionName(String value) {
    if (Objects.equals(this.decisionName, value)) return this;
    return new ImmutableEvaluatedDecisionValue(
        this.decisionId,
        value,
        this.decisionKey,
        this.decisionVersion,
        this.decisionType,
        this.decisionOutput,
        this.evaluatedInputs,
        this.matchedRules);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluatedDecisionValue#getDecisionKey() decisionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluatedDecisionValue withDecisionKey(long value) {
    if (this.decisionKey == value) return this;
    return new ImmutableEvaluatedDecisionValue(
        this.decisionId,
        this.decisionName,
        value,
        this.decisionVersion,
        this.decisionType,
        this.decisionOutput,
        this.evaluatedInputs,
        this.matchedRules);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluatedDecisionValue#getDecisionVersion() decisionVersion} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluatedDecisionValue withDecisionVersion(long value) {
    if (this.decisionVersion == value) return this;
    return new ImmutableEvaluatedDecisionValue(
        this.decisionId,
        this.decisionName,
        this.decisionKey,
        value,
        this.decisionType,
        this.decisionOutput,
        this.evaluatedInputs,
        this.matchedRules);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluatedDecisionValue#getDecisionType() decisionType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluatedDecisionValue withDecisionType(String value) {
    if (Objects.equals(this.decisionType, value)) return this;
    return new ImmutableEvaluatedDecisionValue(
        this.decisionId,
        this.decisionName,
        this.decisionKey,
        this.decisionVersion,
        value,
        this.decisionOutput,
        this.evaluatedInputs,
        this.matchedRules);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluatedDecisionValue#getDecisionOutput() decisionOutput} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionOutput (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluatedDecisionValue withDecisionOutput(String value) {
    if (Objects.equals(this.decisionOutput, value)) return this;
    return new ImmutableEvaluatedDecisionValue(
        this.decisionId,
        this.decisionName,
        this.decisionKey,
        this.decisionVersion,
        this.decisionType,
        value,
        this.evaluatedInputs,
        this.matchedRules);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EvaluatedDecisionValue#getEvaluatedInputs() evaluatedInputs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvaluatedDecisionValue withEvaluatedInputs(EvaluatedInputValue... elements) {
    List<EvaluatedInputValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableEvaluatedDecisionValue(
        this.decisionId,
        this.decisionName,
        this.decisionKey,
        this.decisionVersion,
        this.decisionType,
        this.decisionOutput,
        newValue,
        this.matchedRules);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EvaluatedDecisionValue#getEvaluatedInputs() evaluatedInputs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of evaluatedInputs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvaluatedDecisionValue withEvaluatedInputs(Iterable<? extends EvaluatedInputValue> elements) {
    if (this.evaluatedInputs == elements) return this;
    List<EvaluatedInputValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableEvaluatedDecisionValue(
        this.decisionId,
        this.decisionName,
        this.decisionKey,
        this.decisionVersion,
        this.decisionType,
        this.decisionOutput,
        newValue,
        this.matchedRules);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EvaluatedDecisionValue#getMatchedRules() matchedRules}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvaluatedDecisionValue withMatchedRules(MatchedRuleValue... elements) {
    List<MatchedRuleValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableEvaluatedDecisionValue(
        this.decisionId,
        this.decisionName,
        this.decisionKey,
        this.decisionVersion,
        this.decisionType,
        this.decisionOutput,
        this.evaluatedInputs,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EvaluatedDecisionValue#getMatchedRules() matchedRules}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of matchedRules elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvaluatedDecisionValue withMatchedRules(Iterable<? extends MatchedRuleValue> elements) {
    if (this.matchedRules == elements) return this;
    List<MatchedRuleValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableEvaluatedDecisionValue(
        this.decisionId,
        this.decisionName,
        this.decisionKey,
        this.decisionVersion,
        this.decisionType,
        this.decisionOutput,
        this.evaluatedInputs,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEvaluatedDecisionValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEvaluatedDecisionValue
        && equalTo(0, (ImmutableEvaluatedDecisionValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableEvaluatedDecisionValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(decisionId, another.decisionId)
        && Objects.equals(decisionName, another.decisionName)
        && decisionKey == another.decisionKey
        && decisionVersion == another.decisionVersion
        && Objects.equals(decisionType, another.decisionType)
        && Objects.equals(decisionOutput, another.decisionOutput)
        && evaluatedInputs.equals(another.evaluatedInputs)
        && matchedRules.equals(another.matchedRules);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code decisionId}, {@code decisionName}, {@code decisionKey}, {@code decisionVersion}, {@code decisionType}, {@code decisionOutput}, {@code evaluatedInputs}, {@code matchedRules}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(decisionId);
    h += (h << 5) + Objects.hashCode(decisionName);
    h += (h << 5) + Long.hashCode(decisionKey);
    h += (h << 5) + Long.hashCode(decisionVersion);
    h += (h << 5) + Objects.hashCode(decisionType);
    h += (h << 5) + Objects.hashCode(decisionOutput);
    h += (h << 5) + evaluatedInputs.hashCode();
    h += (h << 5) + matchedRules.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EvaluatedDecisionValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EvaluatedDecisionValue{"
        + "decisionId=" + decisionId
        + ", decisionName=" + decisionName
        + ", decisionKey=" + decisionKey
        + ", decisionVersion=" + decisionVersion
        + ", decisionType=" + decisionType
        + ", decisionOutput=" + decisionOutput
        + ", evaluatedInputs=" + evaluatedInputs
        + ", matchedRules=" + matchedRules
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link EvaluatedDecisionValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EvaluatedDecisionValue instance
   */
  public static ImmutableEvaluatedDecisionValue copyOf(EvaluatedDecisionValue instance) {
    if (instance instanceof ImmutableEvaluatedDecisionValue) {
      return (ImmutableEvaluatedDecisionValue) instance;
    }
    return ImmutableEvaluatedDecisionValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEvaluatedDecisionValue ImmutableEvaluatedDecisionValue}.
   * <pre>
   * ImmutableEvaluatedDecisionValue.builder()
   *    .withDecisionId(String | null) // nullable {@link EvaluatedDecisionValue#getDecisionId() decisionId}
   *    .withDecisionName(String | null) // nullable {@link EvaluatedDecisionValue#getDecisionName() decisionName}
   *    .withDecisionKey(long) // optional {@link EvaluatedDecisionValue#getDecisionKey() decisionKey}
   *    .withDecisionVersion(long) // optional {@link EvaluatedDecisionValue#getDecisionVersion() decisionVersion}
   *    .withDecisionType(String | null) // nullable {@link EvaluatedDecisionValue#getDecisionType() decisionType}
   *    .withDecisionOutput(String | null) // nullable {@link EvaluatedDecisionValue#getDecisionOutput() decisionOutput}
   *    .addEvaluatedInput|addAllEvaluatedInputs(io.camunda.zeebe.protocol.record.value.EvaluatedInputValue) // {@link EvaluatedDecisionValue#getEvaluatedInputs() evaluatedInputs} elements
   *    .addMatchedRule|addAllMatchedRules(io.camunda.zeebe.protocol.record.value.MatchedRuleValue) // {@link EvaluatedDecisionValue#getMatchedRules() matchedRules} elements
   *    .build();
   * </pre>
   * @return A new ImmutableEvaluatedDecisionValue builder
   */
  public static ImmutableEvaluatedDecisionValue.Builder builder() {
    return new ImmutableEvaluatedDecisionValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEvaluatedDecisionValue ImmutableEvaluatedDecisionValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EvaluatedDecisionValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private @Nullable String decisionId;
    private @Nullable String decisionName;
    private long decisionKey;
    private long decisionVersion;
    private @Nullable String decisionType;
    private @Nullable String decisionOutput;
    private List<ImmutableEvaluatedInputValue.Builder> evaluatedInputs = new ArrayList<ImmutableEvaluatedInputValue.Builder>();
    private List<ImmutableMatchedRuleValue.Builder> matchedRules = new ArrayList<ImmutableMatchedRuleValue.Builder>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EvaluatedDecisionValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EvaluatedDecisionValue instance) {
      Objects.requireNonNull(instance, "instance");
      String decisionIdValue = instance.getDecisionId();
      if (decisionIdValue != null) {
        withDecisionId(decisionIdValue);
      }
      String decisionNameValue = instance.getDecisionName();
      if (decisionNameValue != null) {
        withDecisionName(decisionNameValue);
      }
      withDecisionKey(instance.getDecisionKey());
      withDecisionVersion(instance.getDecisionVersion());
      String decisionTypeValue = instance.getDecisionType();
      if (decisionTypeValue != null) {
        withDecisionType(decisionTypeValue);
      }
      String decisionOutputValue = instance.getDecisionOutput();
      if (decisionOutputValue != null) {
        withDecisionOutput(decisionOutputValue);
      }
      addAllEvaluatedInputs(instance.getEvaluatedInputs());
      addAllMatchedRules(instance.getMatchedRules());
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluatedDecisionValue#getDecisionId() decisionId} attribute.
     * @param decisionId The value for decisionId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionId(String decisionId) {
      this.decisionId = decisionId;
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluatedDecisionValue#getDecisionName() decisionName} attribute.
     * @param decisionName The value for decisionName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionName(String decisionName) {
      this.decisionName = decisionName;
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluatedDecisionValue#getDecisionKey() decisionKey} attribute.
     * @param decisionKey The value for decisionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionKey(long decisionKey) {
      this.decisionKey = decisionKey;
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluatedDecisionValue#getDecisionVersion() decisionVersion} attribute.
     * @param decisionVersion The value for decisionVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionVersion(long decisionVersion) {
      this.decisionVersion = decisionVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluatedDecisionValue#getDecisionType() decisionType} attribute.
     * @param decisionType The value for decisionType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionType(String decisionType) {
      this.decisionType = decisionType;
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluatedDecisionValue#getDecisionOutput() decisionOutput} attribute.
     * @param decisionOutput The value for decisionOutput (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionOutput(String decisionOutput) {
      this.decisionOutput = decisionOutput;
      return this;
    }

    /**
     * Adds one element to {@link EvaluatedDecisionValue#getEvaluatedInputs() evaluatedInputs} list.
     * @param element A evaluatedInputs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEvaluatedInput(@Nullable EvaluatedInputValue element) {
      if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(element);
      this.evaluatedInputs.add(ImmutableEvaluatedInputValue.builder().from(element));
      return this;
    }

    /**
     * Adds elements to {@link EvaluatedDecisionValue#getEvaluatedInputs() evaluatedInputs} list.
     * @param elements An array of evaluatedInputs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEvaluatedInputs(EvaluatedInputValue... elements) {
      for (EvaluatedInputValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(element);
        this.evaluatedInputs.add(ImmutableEvaluatedInputValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds a new builder to the {@link EvaluatedDecisionValue#getEvaluatedInputs() evaluatedInputs} list and returns
     * the builder.
     */
    public final ImmutableEvaluatedInputValue.Builder addEvaluatedInputBuilder() {
      ImmutableEvaluatedInputValue.Builder builder = ImmutableEvaluatedInputValue.builder();
      this.evaluatedInputs.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link EvaluatedDecisionValue#getEvaluatedInputs() evaluatedInputs} list.
     * @param elements An array of evaluatedInputs builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEvaluatedInputBuilders(ImmutableEvaluatedInputValue.Builder... elements) {
      for (ImmutableEvaluatedInputValue.Builder element : elements) {
        this.evaluatedInputs.add(element);
      }
      return this;
    }

    /**
     * Gets the builder elements to {@link EvaluatedDecisionValue#getEvaluatedInputs() evaluatedInputs} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<ImmutableEvaluatedInputValue.Builder> evaluatedInputBuilders() {
      return createUnmodifiableList(false, this.evaluatedInputs);
    }

    /**
     * Sets or replaces all elements for {@link EvaluatedDecisionValue#getEvaluatedInputs() evaluatedInputs} list.
     * @param elements An iterable of evaluatedInputs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withEvaluatedInputs(Iterable<? extends EvaluatedInputValue> elements) {
      this.evaluatedInputs.clear();
      return addAllEvaluatedInputs(elements);
    }

    /**
     * Adds elements to {@link EvaluatedDecisionValue#getEvaluatedInputs() evaluatedInputs} list.
     * @param elements An iterable of evaluatedInputs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEvaluatedInputs(Iterable<? extends EvaluatedInputValue> elements) {
      for (EvaluatedInputValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(element);
        this.evaluatedInputs.add(ImmutableEvaluatedInputValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds elements to {@link EvaluatedDecisionValue#getEvaluatedInputs() evaluatedInputs} list.
     * @param elements An iterable of evaluatedInputs builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEvaluatedInputBuilders(Iterable<ImmutableEvaluatedInputValue.Builder> elements) {
      for (ImmutableEvaluatedInputValue.Builder element : elements) {
        this.evaluatedInputs.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link EvaluatedDecisionValue#getMatchedRules() matchedRules} list.
     * @param element A matchedRules element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMatchedRule(@Nullable MatchedRuleValue element) {
      if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(element);
      this.matchedRules.add(ImmutableMatchedRuleValue.builder().from(element));
      return this;
    }

    /**
     * Adds elements to {@link EvaluatedDecisionValue#getMatchedRules() matchedRules} list.
     * @param elements An array of matchedRules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMatchedRules(MatchedRuleValue... elements) {
      for (MatchedRuleValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(element);
        this.matchedRules.add(ImmutableMatchedRuleValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds a new builder to the {@link EvaluatedDecisionValue#getMatchedRules() matchedRules} list and returns
     * the builder.
     */
    public final ImmutableMatchedRuleValue.Builder addMatchedRuleBuilder() {
      ImmutableMatchedRuleValue.Builder builder = ImmutableMatchedRuleValue.builder();
      this.matchedRules.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link EvaluatedDecisionValue#getMatchedRules() matchedRules} list.
     * @param elements An array of matchedRules builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMatchedRuleBuilders(ImmutableMatchedRuleValue.Builder... elements) {
      for (ImmutableMatchedRuleValue.Builder element : elements) {
        this.matchedRules.add(element);
      }
      return this;
    }

    /**
     * Gets the builder elements to {@link EvaluatedDecisionValue#getMatchedRules() matchedRules} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<ImmutableMatchedRuleValue.Builder> matchedRuleBuilders() {
      return createUnmodifiableList(false, this.matchedRules);
    }

    /**
     * Sets or replaces all elements for {@link EvaluatedDecisionValue#getMatchedRules() matchedRules} list.
     * @param elements An iterable of matchedRules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withMatchedRules(Iterable<? extends MatchedRuleValue> elements) {
      this.matchedRules.clear();
      return addAllMatchedRules(elements);
    }

    /**
     * Adds elements to {@link EvaluatedDecisionValue#getMatchedRules() matchedRules} list.
     * @param elements An iterable of matchedRules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMatchedRules(Iterable<? extends MatchedRuleValue> elements) {
      for (MatchedRuleValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(element);
        this.matchedRules.add(ImmutableMatchedRuleValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds elements to {@link EvaluatedDecisionValue#getMatchedRules() matchedRules} list.
     * @param elements An iterable of matchedRules builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMatchedRuleBuilders(Iterable<ImmutableMatchedRuleValue.Builder> elements) {
      for (ImmutableMatchedRuleValue.Builder element : elements) {
        this.matchedRules.add(element);
      }
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.decisionId = null;
      this.decisionName = null;
      this.decisionKey = 0;
      this.decisionVersion = 0;
      this.decisionType = null;
      this.decisionOutput = null;
      this.evaluatedInputs.clear();
      this.matchedRules.clear();
      return this;
    }

    /**
     * Builds a new {@link ImmutableEvaluatedDecisionValue ImmutableEvaluatedDecisionValue}.
     * @return An immutable instance of EvaluatedDecisionValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEvaluatedDecisionValue build() {
      return new ImmutableEvaluatedDecisionValue(
          decisionId,
          decisionName,
          decisionKey,
          decisionVersion,
          decisionType,
          decisionOutput,
          createUnmodifiableList(true, convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(evaluatedInputs)),
          createUnmodifiableList(true, convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(matchedRules)));
    }



    @Nullable 
    private static ImmutableEvaluatedInputValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(@Nullable  ImmutableEvaluatedInputValue.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    @Nullable 
    private static EvaluatedInputValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(@Nullable  EvaluatedInputValue value) {
      if (value == null) return null;
      return ImmutableEvaluatedInputValue.builder().from(value).build();
    }

    @Nullable 
    private static ImmutableEvaluatedInputValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(@Nullable  EvaluatedInputValue value) {
      if (value == null) return null;
      return ImmutableEvaluatedInputValue.builder().from(value);
    }

    @Nullable 
    private static ImmutableMatchedRuleValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(@Nullable  ImmutableMatchedRuleValue.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    @Nullable 
    private static MatchedRuleValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(@Nullable  MatchedRuleValue value) {
      if (value == null) return null;
      return ImmutableMatchedRuleValue.builder().from(value).build();
    }

    @Nullable 
    private static ImmutableMatchedRuleValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(@Nullable  MatchedRuleValue value) {
      if (value == null) return null;
      return ImmutableMatchedRuleValue.builder().from(value);
    }

    private static List<EvaluatedInputValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(Iterable<? extends ImmutableEvaluatedInputValue.Builder> builderList) {
      ArrayList<EvaluatedInputValue> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (ImmutableEvaluatedInputValue.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<EvaluatedInputValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(ImmutableEvaluatedInputValue.Builder... builderArray) {
      ArrayList<EvaluatedInputValue> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (ImmutableEvaluatedInputValue.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ImmutableEvaluatedInputValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(Iterable<? extends ImmutableEvaluatedInputValue> valueList) {
      ArrayList<ImmutableEvaluatedInputValue.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (ImmutableEvaluatedInputValue element : valueList) {
        list.add(ImmutableEvaluatedInputValue.builder().from(element));
      }
      return list;
    }

    private static List<ImmutableEvaluatedInputValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(ImmutableEvaluatedInputValue... valueArray) {
      ArrayList<ImmutableEvaluatedInputValue.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (ImmutableEvaluatedInputValue element : valueArray) {
        list.add(ImmutableEvaluatedInputValue.builder().from(element));
      }
      return list;
    }
    private static List<MatchedRuleValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(Iterable<? extends ImmutableMatchedRuleValue.Builder> builderList) {
      ArrayList<MatchedRuleValue> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (ImmutableMatchedRuleValue.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<MatchedRuleValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(ImmutableMatchedRuleValue.Builder... builderArray) {
      ArrayList<MatchedRuleValue> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (ImmutableMatchedRuleValue.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ImmutableMatchedRuleValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(Iterable<? extends ImmutableMatchedRuleValue> valueList) {
      ArrayList<ImmutableMatchedRuleValue.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (ImmutableMatchedRuleValue element : valueList) {
        list.add(ImmutableMatchedRuleValue.builder().from(element));
      }
      return list;
    }

    private static List<ImmutableMatchedRuleValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(ImmutableMatchedRuleValue... valueArray) {
      ArrayList<ImmutableMatchedRuleValue.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (ImmutableMatchedRuleValue element : valueArray) {
        list.add(ImmutableMatchedRuleValue.builder().from(element));
      }
      return list;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }



  @Nullable 
  private static ImmutableEvaluatedInputValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(@Nullable  ImmutableEvaluatedInputValue.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  @Nullable 
  private static EvaluatedInputValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(@Nullable  EvaluatedInputValue value) {
    if (value == null) return null;
    return ImmutableEvaluatedInputValue.builder().from(value).build();
  }

  @Nullable 
  private static ImmutableEvaluatedInputValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(@Nullable  EvaluatedInputValue value) {
    if (value == null) return null;
    return ImmutableEvaluatedInputValue.builder().from(value);
  }

  @Nullable 
  private static ImmutableMatchedRuleValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(@Nullable  ImmutableMatchedRuleValue.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  @Nullable 
  private static MatchedRuleValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(@Nullable  MatchedRuleValue value) {
    if (value == null) return null;
    return ImmutableMatchedRuleValue.builder().from(value).build();
  }

  @Nullable 
  private static ImmutableMatchedRuleValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(@Nullable  MatchedRuleValue value) {
    if (value == null) return null;
    return ImmutableMatchedRuleValue.builder().from(value);
  }

  private static List<EvaluatedInputValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(Iterable<? extends ImmutableEvaluatedInputValue.Builder> builderList) {
    ArrayList<EvaluatedInputValue> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (ImmutableEvaluatedInputValue.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<EvaluatedInputValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(ImmutableEvaluatedInputValue.Builder... builderArray) {
    ArrayList<EvaluatedInputValue> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (ImmutableEvaluatedInputValue.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ImmutableEvaluatedInputValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(Iterable<? extends ImmutableEvaluatedInputValue> valueList) {
    ArrayList<ImmutableEvaluatedInputValue.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (ImmutableEvaluatedInputValue element : valueList) {
      list.add(ImmutableEvaluatedInputValue.builder().from(element));
    }
    return list;
  }

  private static List<ImmutableEvaluatedInputValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedInputValue(ImmutableEvaluatedInputValue... valueArray) {
    ArrayList<ImmutableEvaluatedInputValue.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (ImmutableEvaluatedInputValue element : valueArray) {
      list.add(ImmutableEvaluatedInputValue.builder().from(element));
    }
    return list;
  }
  private static List<MatchedRuleValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(Iterable<? extends ImmutableMatchedRuleValue.Builder> builderList) {
    ArrayList<MatchedRuleValue> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (ImmutableMatchedRuleValue.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<MatchedRuleValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(ImmutableMatchedRuleValue.Builder... builderArray) {
    ArrayList<MatchedRuleValue> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (ImmutableMatchedRuleValue.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ImmutableMatchedRuleValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(Iterable<? extends ImmutableMatchedRuleValue> valueList) {
    ArrayList<ImmutableMatchedRuleValue.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (ImmutableMatchedRuleValue element : valueList) {
      list.add(ImmutableMatchedRuleValue.builder().from(element));
    }
    return list;
  }

  private static List<ImmutableMatchedRuleValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableMatchedRuleValue(ImmutableMatchedRuleValue... valueArray) {
    ArrayList<ImmutableMatchedRuleValue.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (ImmutableMatchedRuleValue element : valueArray) {
      list.add(ImmutableMatchedRuleValue.builder().from(element));
    }
    return list;
  }
}
