package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessInstanceCreationStartInstructionValue.builder()}.
 */
@Generated(from = "ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@ImmutableProtocol.Type(builder=ImmutableProcessInstanceCreationStartInstructionValue.Builder.class)
public final class ImmutableProcessInstanceCreationStartInstructionValue
    implements ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue {
  private final String elementId;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcessInstanceCreationStartInstructionValue(String elementId) {
    this.elementId = elementId;
  }

  /**
   * @return The value of the {@code elementId} attribute
   */
  @Override
  public String getElementId() {
    return elementId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue#getElementId() elementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceCreationStartInstructionValue withElementId(String value) {
    if (Objects.equals(this.elementId, value)) return this;
    return new ImmutableProcessInstanceCreationStartInstructionValue(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessInstanceCreationStartInstructionValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessInstanceCreationStartInstructionValue
        && equalTo(0, (ImmutableProcessInstanceCreationStartInstructionValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessInstanceCreationStartInstructionValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(elementId, another.elementId);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code elementId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(elementId);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessInstanceCreationStartInstructionValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessInstanceCreationStartInstructionValue{"
        + "elementId=" + elementId
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessInstanceCreationStartInstructionValue instance
   */
  public static ImmutableProcessInstanceCreationStartInstructionValue copyOf(ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue instance) {
    if (instance instanceof ImmutableProcessInstanceCreationStartInstructionValue) {
      return (ImmutableProcessInstanceCreationStartInstructionValue) instance;
    }
    return ImmutableProcessInstanceCreationStartInstructionValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessInstanceCreationStartInstructionValue ImmutableProcessInstanceCreationStartInstructionValue}.
   * <pre>
   * ImmutableProcessInstanceCreationStartInstructionValue.builder()
   *    .withElementId(String | null) // nullable {@link ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue#getElementId() elementId}
   *    .build();
   * </pre>
   * @return A new ImmutableProcessInstanceCreationStartInstructionValue builder
   */
  public static ImmutableProcessInstanceCreationStartInstructionValue.Builder builder() {
    return new ImmutableProcessInstanceCreationStartInstructionValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessInstanceCreationStartInstructionValue ImmutableProcessInstanceCreationStartInstructionValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private @Nullable String elementId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcessInstanceCreationStartInstructionValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue instance) {
      Objects.requireNonNull(instance, "instance");
      String elementIdValue = instance.getElementId();
      if (elementIdValue != null) {
        withElementId(elementIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue#getElementId() elementId} attribute.
     * @param elementId The value for elementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementId(String elementId) {
      this.elementId = elementId;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.elementId = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessInstanceCreationStartInstructionValue ImmutableProcessInstanceCreationStartInstructionValue}.
     * @return An immutable instance of ProcessInstanceCreationStartInstructionValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessInstanceCreationStartInstructionValue build() {
      return new ImmutableProcessInstanceCreationStartInstructionValue(elementId);
    }



  }



}
