package io.camunda.zeebe.protocol.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DecisionRequirementsMetadataValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDecisionRequirementsMetadataValue.builder()}.
 */
@Generated(from = "DecisionRequirementsMetadataValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@ImmutableProtocol.Type(builder=ImmutableDecisionRequirementsMetadataValue.Builder.class)
public final class ImmutableDecisionRequirementsMetadataValue
    implements DecisionRequirementsMetadataValue {
  private final String decisionRequirementsId;
  private final String decisionRequirementsName;
  private final int decisionRequirementsVersion;
  private final long decisionRequirementsKey;
  private final String namespace;
  private final String resourceName;
  private final byte[] checksum;
  private final boolean duplicate;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableDecisionRequirementsMetadataValue(
      String decisionRequirementsId,
      String decisionRequirementsName,
      int decisionRequirementsVersion,
      long decisionRequirementsKey,
      String namespace,
      String resourceName,
      byte[] checksum,
      boolean duplicate) {
    this.decisionRequirementsId = decisionRequirementsId;
    this.decisionRequirementsName = decisionRequirementsName;
    this.decisionRequirementsVersion = decisionRequirementsVersion;
    this.decisionRequirementsKey = decisionRequirementsKey;
    this.namespace = namespace;
    this.resourceName = resourceName;
    this.checksum = checksum;
    this.duplicate = duplicate;
  }

  /**
   * @return the ID of the DRG in the DMN
   */
  @Override
  public String getDecisionRequirementsId() {
    return decisionRequirementsId;
  }

  /**
   * @return the name of the DRG in the DMN
   */
  @Override
  public String getDecisionRequirementsName() {
    return decisionRequirementsName;
  }

  /**
   * @return the version of the deployed DRG
   */
  @Override
  public int getDecisionRequirementsVersion() {
    return decisionRequirementsVersion;
  }

  /**
   * @return the key of the deployed DRG
   */
  @Override
  public long getDecisionRequirementsKey() {
    return decisionRequirementsKey;
  }

  /**
   * @return the namespace of the DRG in the DMN
   */
  @Override
  public String getNamespace() {
    return namespace;
  }

  /**
   * @return the name of the resource through which this DRG was deployed
   */
  @Override
  public String getResourceName() {
    return resourceName;
  }

  /**
   * @return the checksum of the DMN resource (MD5)
   */
  @Override
  public byte[] getChecksum() {
    return checksum;
  }

  /**
   * @return {@code true} if the DRG is a duplicate (and has been deployed previously), otherwise
   *     {@code false}
   */
  @Override
  public boolean isDuplicate() {
    return duplicate;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRequirementsMetadataValue#getDecisionRequirementsId() decisionRequirementsId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionRequirementsId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRequirementsMetadataValue withDecisionRequirementsId(String value) {
    if (Objects.equals(this.decisionRequirementsId, value)) return this;
    return new ImmutableDecisionRequirementsMetadataValue(
        value,
        this.decisionRequirementsName,
        this.decisionRequirementsVersion,
        this.decisionRequirementsKey,
        this.namespace,
        this.resourceName,
        this.checksum,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRequirementsMetadataValue#getDecisionRequirementsName() decisionRequirementsName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionRequirementsName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRequirementsMetadataValue withDecisionRequirementsName(String value) {
    if (Objects.equals(this.decisionRequirementsName, value)) return this;
    return new ImmutableDecisionRequirementsMetadataValue(
        this.decisionRequirementsId,
        value,
        this.decisionRequirementsVersion,
        this.decisionRequirementsKey,
        this.namespace,
        this.resourceName,
        this.checksum,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRequirementsMetadataValue#getDecisionRequirementsVersion() decisionRequirementsVersion} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionRequirementsVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRequirementsMetadataValue withDecisionRequirementsVersion(int value) {
    if (this.decisionRequirementsVersion == value) return this;
    return new ImmutableDecisionRequirementsMetadataValue(
        this.decisionRequirementsId,
        this.decisionRequirementsName,
        value,
        this.decisionRequirementsKey,
        this.namespace,
        this.resourceName,
        this.checksum,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRequirementsMetadataValue#getDecisionRequirementsKey() decisionRequirementsKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionRequirementsKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRequirementsMetadataValue withDecisionRequirementsKey(long value) {
    if (this.decisionRequirementsKey == value) return this;
    return new ImmutableDecisionRequirementsMetadataValue(
        this.decisionRequirementsId,
        this.decisionRequirementsName,
        this.decisionRequirementsVersion,
        value,
        this.namespace,
        this.resourceName,
        this.checksum,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRequirementsMetadataValue#getNamespace() namespace} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for namespace (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRequirementsMetadataValue withNamespace(String value) {
    if (Objects.equals(this.namespace, value)) return this;
    return new ImmutableDecisionRequirementsMetadataValue(
        this.decisionRequirementsId,
        this.decisionRequirementsName,
        this.decisionRequirementsVersion,
        this.decisionRequirementsKey,
        value,
        this.resourceName,
        this.checksum,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRequirementsMetadataValue#getResourceName() resourceName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resourceName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRequirementsMetadataValue withResourceName(String value) {
    if (Objects.equals(this.resourceName, value)) return this;
    return new ImmutableDecisionRequirementsMetadataValue(
        this.decisionRequirementsId,
        this.decisionRequirementsName,
        this.decisionRequirementsVersion,
        this.decisionRequirementsKey,
        this.namespace,
        value,
        this.checksum,
        this.duplicate);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DecisionRequirementsMetadataValue#getChecksum() checksum}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for checksum
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDecisionRequirementsMetadataValue withChecksum(byte... elements) {
    byte[] newValue = elements == null ? null : elements.clone();
    return new ImmutableDecisionRequirementsMetadataValue(
        this.decisionRequirementsId,
        this.decisionRequirementsName,
        this.decisionRequirementsVersion,
        this.decisionRequirementsKey,
        this.namespace,
        this.resourceName,
        newValue,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRequirementsMetadataValue#isDuplicate() duplicate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for duplicate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRequirementsMetadataValue withDuplicate(boolean value) {
    if (this.duplicate == value) return this;
    return new ImmutableDecisionRequirementsMetadataValue(
        this.decisionRequirementsId,
        this.decisionRequirementsName,
        this.decisionRequirementsVersion,
        this.decisionRequirementsKey,
        this.namespace,
        this.resourceName,
        this.checksum,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDecisionRequirementsMetadataValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDecisionRequirementsMetadataValue
        && equalTo(0, (ImmutableDecisionRequirementsMetadataValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableDecisionRequirementsMetadataValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(decisionRequirementsId, another.decisionRequirementsId)
        && Objects.equals(decisionRequirementsName, another.decisionRequirementsName)
        && decisionRequirementsVersion == another.decisionRequirementsVersion
        && decisionRequirementsKey == another.decisionRequirementsKey
        && Objects.equals(namespace, another.namespace)
        && Objects.equals(resourceName, another.resourceName)
        && Arrays.equals(checksum, another.checksum)
        && duplicate == another.duplicate;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code decisionRequirementsId}, {@code decisionRequirementsName}, {@code decisionRequirementsVersion}, {@code decisionRequirementsKey}, {@code namespace}, {@code resourceName}, {@code checksum}, {@code duplicate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(decisionRequirementsId);
    h += (h << 5) + Objects.hashCode(decisionRequirementsName);
    h += (h << 5) + decisionRequirementsVersion;
    h += (h << 5) + Long.hashCode(decisionRequirementsKey);
    h += (h << 5) + Objects.hashCode(namespace);
    h += (h << 5) + Objects.hashCode(resourceName);
    h += (h << 5) + Arrays.hashCode(checksum);
    h += (h << 5) + Boolean.hashCode(duplicate);
    return h;
  }

  /**
   * Prints the immutable value {@code DecisionRequirementsMetadataValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DecisionRequirementsMetadataValue{"
        + "decisionRequirementsId=" + decisionRequirementsId
        + ", decisionRequirementsName=" + decisionRequirementsName
        + ", decisionRequirementsVersion=" + decisionRequirementsVersion
        + ", decisionRequirementsKey=" + decisionRequirementsKey
        + ", namespace=" + namespace
        + ", resourceName=" + resourceName
        + ", checksum=" + Arrays.toString(checksum)
        + ", duplicate=" + duplicate
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DecisionRequirementsMetadataValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DecisionRequirementsMetadataValue instance
   */
  public static ImmutableDecisionRequirementsMetadataValue copyOf(DecisionRequirementsMetadataValue instance) {
    if (instance instanceof ImmutableDecisionRequirementsMetadataValue) {
      return (ImmutableDecisionRequirementsMetadataValue) instance;
    }
    return ImmutableDecisionRequirementsMetadataValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDecisionRequirementsMetadataValue ImmutableDecisionRequirementsMetadataValue}.
   * <pre>
   * ImmutableDecisionRequirementsMetadataValue.builder()
   *    .withDecisionRequirementsId(String | null) // nullable {@link DecisionRequirementsMetadataValue#getDecisionRequirementsId() decisionRequirementsId}
   *    .withDecisionRequirementsName(String | null) // nullable {@link DecisionRequirementsMetadataValue#getDecisionRequirementsName() decisionRequirementsName}
   *    .withDecisionRequirementsVersion(int) // optional {@link DecisionRequirementsMetadataValue#getDecisionRequirementsVersion() decisionRequirementsVersion}
   *    .withDecisionRequirementsKey(long) // optional {@link DecisionRequirementsMetadataValue#getDecisionRequirementsKey() decisionRequirementsKey}
   *    .withNamespace(String | null) // nullable {@link DecisionRequirementsMetadataValue#getNamespace() namespace}
   *    .withResourceName(String | null) // nullable {@link DecisionRequirementsMetadataValue#getResourceName() resourceName}
   *    .withChecksum(byte[] | null) // nullable {@link DecisionRequirementsMetadataValue#getChecksum() checksum}
   *    .withDuplicate(boolean) // optional {@link DecisionRequirementsMetadataValue#isDuplicate() duplicate}
   *    .build();
   * </pre>
   * @return A new ImmutableDecisionRequirementsMetadataValue builder
   */
  public static ImmutableDecisionRequirementsMetadataValue.Builder builder() {
    return new ImmutableDecisionRequirementsMetadataValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDecisionRequirementsMetadataValue ImmutableDecisionRequirementsMetadataValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DecisionRequirementsMetadataValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private @Nullable String decisionRequirementsId;
    private @Nullable String decisionRequirementsName;
    private int decisionRequirementsVersion;
    private long decisionRequirementsKey;
    private @Nullable String namespace;
    private @Nullable String resourceName;
    private @Nullable byte[] checksum;
    private boolean duplicate;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DecisionRequirementsMetadataValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DecisionRequirementsMetadataValue instance) {
      Objects.requireNonNull(instance, "instance");
      String decisionRequirementsIdValue = instance.getDecisionRequirementsId();
      if (decisionRequirementsIdValue != null) {
        withDecisionRequirementsId(decisionRequirementsIdValue);
      }
      String decisionRequirementsNameValue = instance.getDecisionRequirementsName();
      if (decisionRequirementsNameValue != null) {
        withDecisionRequirementsName(decisionRequirementsNameValue);
      }
      withDecisionRequirementsVersion(instance.getDecisionRequirementsVersion());
      withDecisionRequirementsKey(instance.getDecisionRequirementsKey());
      String namespaceValue = instance.getNamespace();
      if (namespaceValue != null) {
        withNamespace(namespaceValue);
      }
      String resourceNameValue = instance.getResourceName();
      if (resourceNameValue != null) {
        withResourceName(resourceNameValue);
      }
      byte[] checksumValue = instance.getChecksum();
      if (checksumValue != null) {
        withChecksum(checksumValue);
      }
      withDuplicate(instance.isDuplicate());
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsMetadataValue#getDecisionRequirementsId() decisionRequirementsId} attribute.
     * @param decisionRequirementsId The value for decisionRequirementsId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionRequirementsId(String decisionRequirementsId) {
      this.decisionRequirementsId = decisionRequirementsId;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsMetadataValue#getDecisionRequirementsName() decisionRequirementsName} attribute.
     * @param decisionRequirementsName The value for decisionRequirementsName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionRequirementsName(String decisionRequirementsName) {
      this.decisionRequirementsName = decisionRequirementsName;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsMetadataValue#getDecisionRequirementsVersion() decisionRequirementsVersion} attribute.
     * @param decisionRequirementsVersion The value for decisionRequirementsVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionRequirementsVersion(int decisionRequirementsVersion) {
      this.decisionRequirementsVersion = decisionRequirementsVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsMetadataValue#getDecisionRequirementsKey() decisionRequirementsKey} attribute.
     * @param decisionRequirementsKey The value for decisionRequirementsKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionRequirementsKey(long decisionRequirementsKey) {
      this.decisionRequirementsKey = decisionRequirementsKey;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsMetadataValue#getNamespace() namespace} attribute.
     * @param namespace The value for namespace (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withNamespace(String namespace) {
      this.namespace = namespace;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsMetadataValue#getResourceName() resourceName} attribute.
     * @param resourceName The value for resourceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResourceName(String resourceName) {
      this.resourceName = resourceName;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsMetadataValue#getChecksum() checksum} attribute.
     * @param checksum The elements for checksum
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withChecksum(byte... checksum) {
      this.checksum = checksum;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRequirementsMetadataValue#isDuplicate() duplicate} attribute.
     * @param duplicate The value for duplicate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDuplicate(boolean duplicate) {
      this.duplicate = duplicate;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.decisionRequirementsId = null;
      this.decisionRequirementsName = null;
      this.decisionRequirementsVersion = 0;
      this.decisionRequirementsKey = 0;
      this.namespace = null;
      this.resourceName = null;
      this.checksum = null;
      this.duplicate = false;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDecisionRequirementsMetadataValue ImmutableDecisionRequirementsMetadataValue}.
     * @return An immutable instance of DecisionRequirementsMetadataValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDecisionRequirementsMetadataValue build() {
      return new ImmutableDecisionRequirementsMetadataValue(
          decisionRequirementsId,
          decisionRequirementsName,
          decisionRequirementsVersion,
          decisionRequirementsKey,
          namespace,
          resourceName,
          checksum,
          duplicate);
    }



  }



}
