/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.history.TableChanges;
import io.debezium.util.SchemaNameAdjuster;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectTableChangeSerializer
implements TableChanges.TableChangesSerializer<List<Struct>> {
    public static final String ID_KEY = "id";
    public static final String TYPE_KEY = "type";
    public static final String TABLE_KEY = "table";
    public static final String DEFAULT_CHARSET_NAME_KEY = "defaultCharsetName";
    public static final String PRIMARY_KEY_COLUMN_NAMES_KEY = "primaryKeyColumnNames";
    public static final String COLUMNS_KEY = "columns";
    public static final String NAME_KEY = "name";
    public static final String JDBC_TYPE_KEY = "jdbcType";
    public static final String NATIVE_TYPE_KEY = "nativeType";
    public static final String TYPE_NAME_KEY = "typeName";
    public static final String TYPE_EXPRESSION_KEY = "typeExpression";
    public static final String CHARSET_NAME_KEY = "charsetName";
    public static final String LENGTH_KEY = "length";
    public static final String SCALE_KEY = "scale";
    public static final String POSITION_KEY = "position";
    public static final String OPTIONAL_KEY = "optional";
    public static final String AUTO_INCREMENTED_KEY = "autoIncremented";
    public static final String GENERATED_KEY = "generated";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectTableChangeSerializer.class);
    private static final SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create();
    private static final Schema COLUMN_SCHEMA = SchemaBuilder.struct().name(schemaNameAdjuster.adjust("io.debezium.connector.schema.Column")).field("name", Schema.STRING_SCHEMA).field("jdbcType", Schema.INT32_SCHEMA).field("nativeType", Schema.OPTIONAL_INT32_SCHEMA).field("typeName", Schema.STRING_SCHEMA).field("typeExpression", Schema.OPTIONAL_STRING_SCHEMA).field("charsetName", Schema.OPTIONAL_STRING_SCHEMA).field("length", Schema.OPTIONAL_INT32_SCHEMA).field("scale", Schema.OPTIONAL_INT32_SCHEMA).field("position", Schema.INT32_SCHEMA).field("optional", Schema.OPTIONAL_BOOLEAN_SCHEMA).field("autoIncremented", Schema.OPTIONAL_BOOLEAN_SCHEMA).field("generated", Schema.OPTIONAL_BOOLEAN_SCHEMA).build();
    private static final Schema TABLE_SCHEMA = SchemaBuilder.struct().name(schemaNameAdjuster.adjust("io.debezium.connector.schema.Table")).field("defaultCharsetName", Schema.OPTIONAL_STRING_SCHEMA).field("primaryKeyColumnNames", SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).optional().build()).field("columns", SchemaBuilder.array((Schema)COLUMN_SCHEMA).build()).build();
    public static final Schema CHANGE_SCHEMA = SchemaBuilder.struct().name(schemaNameAdjuster.adjust("io.debezium.connector.schema.Change")).field("type", Schema.STRING_SCHEMA).field("id", Schema.STRING_SCHEMA).field("table", TABLE_SCHEMA).build();

    @Override
    public List<Struct> serialize(TableChanges tableChanges) {
        return StreamSupport.stream(tableChanges.spliterator(), false).map(this::toStruct).collect(Collectors.toList());
    }

    public Struct toStruct(TableChanges.TableChange tableChange) {
        Struct struct = new Struct(CHANGE_SCHEMA);
        struct.put(TYPE_KEY, (Object)tableChange.getType().name());
        struct.put(ID_KEY, (Object)tableChange.getId().toDoubleQuotedString());
        struct.put(TABLE_KEY, (Object)this.toStruct(tableChange.getTable()));
        return struct;
    }

    private Struct toStruct(Table table) {
        Struct struct = new Struct(TABLE_SCHEMA);
        struct.put(DEFAULT_CHARSET_NAME_KEY, (Object)table.defaultCharsetName());
        struct.put(PRIMARY_KEY_COLUMN_NAMES_KEY, table.primaryKeyColumnNames());
        List columns = table.columns().stream().map(this::toStruct).collect(Collectors.toList());
        struct.put(COLUMNS_KEY, columns);
        return struct;
    }

    private Struct toStruct(Column column) {
        Struct struct = new Struct(COLUMN_SCHEMA);
        struct.put(NAME_KEY, (Object)column.name());
        struct.put(JDBC_TYPE_KEY, (Object)column.jdbcType());
        if (column.nativeType() != -1) {
            struct.put(NATIVE_TYPE_KEY, (Object)column.nativeType());
        }
        struct.put(TYPE_NAME_KEY, (Object)column.typeName());
        struct.put(TYPE_EXPRESSION_KEY, (Object)column.typeExpression());
        struct.put(CHARSET_NAME_KEY, (Object)column.charsetName());
        if (column.length() != -1) {
            struct.put(LENGTH_KEY, (Object)column.length());
        }
        column.scale().ifPresent(s -> struct.put(SCALE_KEY, s));
        struct.put(POSITION_KEY, (Object)column.position());
        struct.put(OPTIONAL_KEY, (Object)column.isOptional());
        struct.put(AUTO_INCREMENTED_KEY, (Object)column.isAutoIncremented());
        struct.put(GENERATED_KEY, (Object)column.isGenerated());
        return struct;
    }

    @Override
    public TableChanges deserialize(List<Struct> data, boolean useCatalogBeforeSchema) {
        throw new UnsupportedOperationException("Deserialization from Connect Struct is not supported");
    }
}

