/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import java.io.File;
import java.io.IOException;

public class DockerPathUtil {
    public static File resolveAbsolutely(String pathToResolve, String baseDir) {
        File fileToResolve = new File(pathToResolve);
        if (fileToResolve.isAbsolute()) {
            return fileToResolve;
        }
        if (baseDir == null) {
            throw new IllegalArgumentException("Cannot resolve relative path '" + pathToResolve + "' with a null base directory.");
        }
        File baseDirAsFile = new File(baseDir);
        if (!baseDirAsFile.isAbsolute()) {
            throw new IllegalArgumentException("Base directory '" + baseDirAsFile + "' must be absolute");
        }
        File toCanonicalize = new File(baseDirAsFile, pathToResolve);
        try {
            return toCanonicalize.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to canonicalize the file path '" + toCanonicalize + "'");
        }
    }
}

