/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.wait;

import io.fabric8.maven.docker.config.WaitConfiguration;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.wait.WaitChecker;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class HttpPingChecker
implements WaitChecker {
    private int statusMin;
    private int statusMax;
    private String url;
    private String method;
    private boolean allowAllHosts;
    private final Logger log;
    private static final int HTTP_CLIENT_RETRIES = 0;
    private static final int HTTP_PING_TIMEOUT = 500;

    public HttpPingChecker(String url, String method, String status, Logger log) {
        this.url = url;
        this.method = method;
        this.log = log;
        Matcher matcher = Pattern.compile("^(\\d+)\\s*\\.\\.+\\s*(\\d+)$").matcher(status);
        if (matcher.matches()) {
            this.statusMin = Integer.parseInt(matcher.group(1));
            this.statusMax = Integer.parseInt(matcher.group(2));
        } else {
            this.statusMin = this.statusMax = Integer.parseInt(status);
        }
    }

    public HttpPingChecker(String waitUrl, Logger log) {
        this(waitUrl, "HEAD", WaitConfiguration.DEFAULT_STATUS_RANGE, log);
    }

    public HttpPingChecker(String url, String method, String status, boolean allowAllHosts, Logger log) {
        this(url, method, status, log);
        this.allowAllHosts = allowAllHosts;
    }

    @Override
    public boolean check() {
        try {
            return this.ping();
        }
        catch (IOException exception) {
            this.log.debug("Check failed due to %s: %s", exception.getMessage(), exception);
            return false;
        }
    }

    private boolean ping() throws IOException {
        CloseableHttpClient httpClient;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(500).setConnectTimeout(500).setConnectionRequestTimeout(500).setRedirectsEnabled(false).build();
        if (this.allowAllHosts) {
            SSLContextBuilder builder = new SSLContextBuilder();
            try {
                builder.loadTrustMaterial((TrustStrategy)new TrustAllStrategy());
                SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false)).setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new IOException("Unable to set self signed strategy on http wait: " + e, e);
            }
        } else {
            httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false)).build();
        }
        this.log.debug("Checking %s %s", this.method.toUpperCase(), this.url);
        try {
            boolean bl;
            block14: {
                CloseableHttpResponse response = httpClient.execute(RequestBuilder.create((String)this.method.toUpperCase()).setUri(this.url).build());
                try {
                    int responseCode = response.getStatusLine().getStatusCode();
                    if (responseCode == 501) {
                        throw new IllegalArgumentException("Invalid or not supported HTTP method '" + this.method.toUpperCase() + "' for checking " + this.url);
                    }
                    this.log.debug("%s %s returned %s", this.method.toUpperCase(), this.url, responseCode);
                    boolean bl2 = bl = responseCode >= this.statusMin && responseCode <= this.statusMax;
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return bl;
        }
        finally {
            httpClient.close();
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public String getLogLabel() {
        return "on url " + this.url;
    }
}

