/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.gradle;

import io.github.fvarrui.javapackager.model.Manifest;
import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.Packager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.bundling.Jar;

public class CreateRunnableJar
extends ArtifactGenerator<Packager> {
    public CreateRunnableJar() {
        super("Runnable JAR");
    }

    @Override
    protected File doApply(Packager packager) {
        String classifier = "runnable";
        String name = packager.getName();
        String version = packager.getVersion();
        String mainClass = packager.getMainClass();
        File outputDirectory = packager.getOutputDirectory();
        Project project = Context.getGradleContext().getProject();
        File libsFolder = packager.getLibsFolder();
        Manifest manifest = packager.getManifest();
        List<Object> dependencies = new ArrayList();
        if (libsFolder != null && libsFolder.exists()) {
            dependencies = Arrays.asList(libsFolder.listFiles()).stream().map(f -> libsFolder.getName() + "/" + f.getName()).collect(Collectors.toList());
        }
        Jar jarTask = (Jar)project.getTasks().findByName("jar");
        jarTask.setProperty("archiveBaseName", (Object)name);
        jarTask.setProperty("archiveVersion", (Object)version);
        jarTask.setProperty("archiveClassifier", (Object)classifier);
        jarTask.setProperty("destinationDirectory", (Object)outputDirectory);
        jarTask.getManifest().getAttributes().put((Object)"Created-By", (Object)("Gradle " + Context.getGradleContext().getProject().getGradle().getGradleVersion()));
        jarTask.getManifest().getAttributes().put((Object)"Built-By", (Object)System.getProperty("user.name"));
        jarTask.getManifest().getAttributes().put((Object)"Build-Jdk", (Object)System.getProperty("java.version"));
        jarTask.getManifest().getAttributes().put((Object)"Class-Path", (Object)StringUtils.join(dependencies, (String)" "));
        jarTask.getManifest().getAttributes().put((Object)"Main-Class", (Object)mainClass);
        if (manifest != null) {
            jarTask.getManifest().attributes(manifest.getAdditionalEntries());
            manifest.getSections().stream().forEach(s -> jarTask.getManifest().attributes(s.getEntries(), s.getName()));
        }
        jarTask.getActions().forEach(action -> action.execute((Object)jarTask));
        return ((RegularFile)jarTask.getArchiveFile().get()).getAsFile();
    }
}

