/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.gradle;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.MacPackager;
import io.github.fvarrui.javapackager.packagers.Packager;
import java.io.File;
import java.util.UUID;
import org.gradle.api.tasks.bundling.Compression;
import org.gradle.api.tasks.bundling.Tar;

public class CreateTarball
extends ArtifactGenerator<Packager> {
    public CreateTarball() {
        super("Tarball");
    }

    @Override
    public boolean skip(Packager packager) {
        return packager.getCreateTarball() == false;
    }

    @Override
    protected File doApply(Packager packager) throws Exception {
        String name = packager.getName();
        String version = packager.getVersion();
        Platform platform = packager.getPlatform();
        File outputDirectory = packager.getOutputDirectory();
        File appFolder = packager.getAppFolder();
        File executable = packager.getExecutable();
        String jreDirectoryName = packager.getJreDirectoryName();
        File tarFile = new File(outputDirectory, name + "-" + version + "-" + (Object)((Object)platform) + ".tar.gz");
        Tar tarTask = this.createTarTask();
        tarTask.setProperty("archiveFileName", (Object)tarFile.getName());
        tarTask.setProperty("destinationDirectory", (Object)outputDirectory);
        tarTask.setCompression(Compression.GZIP);
        if (Platform.windows.equals((Object)platform)) {
            tarTask.from((Object)appFolder.getParentFile(), copySpec -> copySpec.include(new String[]{appFolder.getName() + "/**"}));
        } else if (Platform.linux.equals((Object)platform)) {
            tarTask.from((Object)appFolder.getParentFile(), copySpec -> {
                copySpec.include(new String[]{appFolder.getName() + "/**"});
                copySpec.exclude(new String[]{appFolder.getName() + "/" + executable.getName()});
                copySpec.exclude(new String[]{appFolder.getName() + "/" + jreDirectoryName + "/bin/*"});
                copySpec.exclude(new String[]{appFolder.getName() + "/scripts/*"});
            });
            tarTask.from((Object)appFolder.getParentFile(), copySpec -> {
                copySpec.include(new String[]{appFolder.getName() + "/" + executable.getName()});
                copySpec.include(new String[]{appFolder.getName() + "/" + jreDirectoryName + "/bin/*"});
                copySpec.include(new String[]{appFolder.getName() + "/scripts/*"});
                copySpec.setFileMode(Integer.valueOf(493));
            });
        } else if (Platform.mac.equals((Object)platform)) {
            MacPackager macPackager = (MacPackager)packager;
            File appFile = macPackager.getAppFile();
            tarTask.from((Object)appFolder, copySpec -> {
                copySpec.include(new String[]{appFile.getName() + "/**"});
                copySpec.exclude(new String[]{appFile.getName() + "/Contents/MacOS/" + executable.getName()});
                copySpec.exclude(new String[]{appFile.getName() + "/Contents/MacOS/universalJavaApplicationStub"});
                copySpec.exclude(new String[]{appFile.getName() + "/Contents/PlugIns/" + jreDirectoryName + "/Contents/Home/bin/*"});
                copySpec.exclude(new String[]{appFile.getName() + "/Contents/Resources/scripts/*"});
            });
            tarTask.from((Object)appFolder, copySpec -> {
                copySpec.include(new String[]{appFile.getName() + "/Contents/MacOS/" + executable.getName()});
                copySpec.include(new String[]{appFile.getName() + "/Contents/MacOS/universalJavaApplicationStub"});
                copySpec.include(new String[]{appFile.getName() + "/Contents/PlugIns/" + jreDirectoryName + "/Contents/Home/bin/*"});
                copySpec.include(new String[]{appFile.getName() + "/Contents/Resources/scripts/*"});
                copySpec.setFileMode(Integer.valueOf(493));
            });
        }
        tarTask.getActions().forEach(action -> action.execute((Object)tarTask));
        return tarFile;
    }

    private Tar createTarTask() {
        return (Tar)Context.getGradleContext().getProject().getTasks().create("createTarball_" + UUID.randomUUID(), Tar.class);
    }
}

