/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.gradle;

import edu.sc.seis.launch4j.tasks.Launch4jLibraryTask;
import io.github.fvarrui.javapackager.gradle.CopyDependencies;
import io.github.fvarrui.javapackager.gradle.CreateRunnableJar;
import io.github.fvarrui.javapackager.gradle.CreateTarball;
import io.github.fvarrui.javapackager.gradle.CreateWindowsExeLaunch4j;
import io.github.fvarrui.javapackager.gradle.CreateZipball;
import io.github.fvarrui.javapackager.packagers.AbstractCreateWindowsExe;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.CreateWindowsExeWinRun4j;
import io.github.fvarrui.javapackager.packagers.Packager;
import io.github.fvarrui.javapackager.packagers.WindowsPackager;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;

public class GradleContext
extends Context<Logger> {
    private Project project;
    private Launch4jLibraryTask libraryTask;

    public GradleContext(Project project) {
        this.project = project;
    }

    @Override
    public Logger getLogger() {
        return this.project.getLogger();
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public File getRootDir() {
        return this.project.getRootDir();
    }

    @Override
    public File getBuildDir() {
        return this.project.getBuildDir();
    }

    @Override
    public File createRunnableJar(Packager packager) throws Exception {
        return new CreateRunnableJar().apply(packager);
    }

    @Override
    public File copyDependencies(Packager packager) throws Exception {
        return new CopyDependencies().apply(packager);
    }

    @Override
    public File createTarball(Packager packager) throws Exception {
        return new CreateTarball().apply(packager);
    }

    @Override
    public File createZipball(Packager packager) throws Exception {
        return new CreateZipball().apply(packager);
    }

    @Override
    public File resolveLicense(Packager packager) throws Exception {
        return null;
    }

    public Launch4jLibraryTask getLibraryTask() {
        return this.libraryTask;
    }

    public void setLibraryTask(Launch4jLibraryTask libraryTask) {
        this.libraryTask = libraryTask;
    }

    @Override
    public File getDefaultToolchain() {
        if (this.project.getGradle().getGradleVersion().compareTo("7") >= 0) {
            return this.getToolchain();
        }
        return super.getDefaultToolchain();
    }

    private File getToolchain() {
        JavaToolchainSpec toolchain = ((JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class)).getToolchain();
        JavaToolchainService service = (JavaToolchainService)this.project.getExtensions().getByType(JavaToolchainService.class);
        Provider defaultLauncher = service.launcherFor(toolchain).orElse((Provider)Providers.notDefined());
        if (defaultLauncher.isPresent()) {
            return ((JavaLauncher)defaultLauncher.get()).getMetadata().getInstallationPath().getAsFile();
        }
        return super.getDefaultToolchain();
    }

    @Override
    public File createWindowsExe(WindowsPackager packager) throws Exception {
        AbstractCreateWindowsExe createWindowsExe;
        switch (packager.getWinConfig().getExeCreationTool()) {
            case launch4j: {
                createWindowsExe = new CreateWindowsExeLaunch4j();
                break;
            }
            case winrun4j: {
                createWindowsExe = new CreateWindowsExeWinRun4j();
                break;
            }
            default: {
                return null;
            }
        }
        if (!createWindowsExe.skip(packager)) {
            return createWindowsExe.apply(packager);
        }
        return null;
    }
}

