/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.model;

import io.github.fvarrui.javapackager.model.HeaderType;
import io.github.fvarrui.javapackager.model.Registry;
import io.github.fvarrui.javapackager.model.SetupMode;
import io.github.fvarrui.javapackager.model.WindowsExeCreationTool;
import io.github.fvarrui.javapackager.model.WindowsSigning;
import io.github.fvarrui.javapackager.packagers.Packager;
import io.github.fvarrui.javapackager.utils.ObjectUtils;
import java.io.File;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class WindowsConfig
implements Serializable {
    private static final long serialVersionUID = 2106752412224694318L;
    private File icoFile;
    private HeaderType headerType;
    private String companyName;
    private String copyright;
    private String fileDescription;
    private String fileVersion;
    private String internalName;
    private String language;
    private String originalFilename;
    private String productName;
    private String productVersion;
    private String trademarks;
    private String txtFileVersion;
    private String txtProductVersion;
    private boolean disableDirPage = true;
    private boolean disableProgramGroupPage = true;
    private boolean disableFinishedPage = true;
    private boolean disableRunAfterInstall = true;
    private boolean disableWelcomePage = true;
    private boolean createDesktopIconTask = true;
    private boolean generateSetup = true;
    private boolean generateMsi = true;
    private boolean generateMsm = false;
    private String msiUpgradeCode;
    private boolean wrapJar = true;
    private LinkedHashMap<String, String> setupLanguages = new LinkedHashMap();
    private SetupMode setupMode = SetupMode.installForAllUsers;
    private WindowsSigning signing;
    private Registry registry = new Registry();
    private boolean removeOldLibs = false;
    private WindowsExeCreationTool exeCreationTool = WindowsExeCreationTool.launch4j;

    public File getIcoFile() {
        return this.icoFile;
    }

    public void setIcoFile(File icoFile) {
        this.icoFile = icoFile;
    }

    public HeaderType getHeaderType() {
        return this.headerType;
    }

    public void setHeaderType(HeaderType headerType) {
        this.headerType = headerType;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getFileDescription() {
        return this.fileDescription;
    }

    public void setFileDescription(String fileDescription) {
        this.fileDescription = fileDescription;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(String fileVersion) {
        this.fileVersion = fileVersion;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public void setOriginalFilename(String originalFilename) {
        this.originalFilename = originalFilename;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getTrademarks() {
        return this.trademarks;
    }

    public void setTrademarks(String trademarks) {
        this.trademarks = trademarks;
    }

    public String getTxtFileVersion() {
        return this.txtFileVersion;
    }

    public void setTxtFileVersion(String txtFileVersion) {
        this.txtFileVersion = txtFileVersion;
    }

    public String getTxtProductVersion() {
        return this.txtProductVersion;
    }

    public void setTxtProductVersion(String txtProductVersion) {
        this.txtProductVersion = txtProductVersion;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public boolean isDisableDirPage() {
        return this.disableDirPage;
    }

    public void setDisableDirPage(boolean disableDirPage) {
        this.disableDirPage = disableDirPage;
    }

    public boolean isDisableProgramGroupPage() {
        return this.disableProgramGroupPage;
    }

    public void setDisableProgramGroupPage(boolean disableProgramGroupPage) {
        this.disableProgramGroupPage = disableProgramGroupPage;
    }

    public boolean isDisableFinishedPage() {
        return this.disableFinishedPage;
    }

    public void setDisableFinishedPage(boolean disableFinishedPage) {
        this.disableFinishedPage = disableFinishedPage;
    }

    public boolean isCreateDesktopIconTask() {
        return this.createDesktopIconTask;
    }

    public void setCreateDesktopIconTask(boolean createDesktopIconTask) {
        this.createDesktopIconTask = createDesktopIconTask;
    }

    public boolean isGenerateSetup() {
        return this.generateSetup;
    }

    public void setGenerateSetup(boolean generateSetup) {
        this.generateSetup = generateSetup;
    }

    public boolean isGenerateMsi() {
        return this.generateMsi;
    }

    public void setGenerateMsi(boolean generateMsi) {
        this.generateMsi = generateMsi;
    }

    public boolean isGenerateMsm() {
        return this.generateMsm;
    }

    public void setGenerateMsm(boolean generateMsm) {
        this.generateMsm = generateMsm;
    }

    public String getMsiUpgradeCode() {
        return this.msiUpgradeCode;
    }

    public void setMsiUpgradeCode(String msiUpgradeCode) {
        this.msiUpgradeCode = msiUpgradeCode;
    }

    public boolean isWrapJar() {
        return this.wrapJar;
    }

    public void setWrapJar(boolean wrapJar) {
        this.wrapJar = wrapJar;
    }

    public LinkedHashMap<String, String> getSetupLanguages() {
        return this.setupLanguages;
    }

    public void setSetupLanguages(LinkedHashMap<String, String> setupLanguages) {
        this.setupLanguages = setupLanguages;
    }

    public SetupMode getSetupMode() {
        return this.setupMode;
    }

    public void setSetupMode(SetupMode setupMode) {
        this.setupMode = setupMode;
    }

    public WindowsSigning getSigning() {
        return this.signing;
    }

    public void setSigning(WindowsSigning signing) {
        this.signing = signing;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public boolean isDisableRunAfterInstall() {
        return this.disableRunAfterInstall;
    }

    public void setDisableRunAfterInstall(boolean disableRunAfterInstall) {
        this.disableRunAfterInstall = disableRunAfterInstall;
    }

    public void setDisableWelcomePage(boolean disableWelcomePage) {
        this.disableWelcomePage = disableWelcomePage;
    }

    public boolean isDisableWelcomePage() {
        return this.disableWelcomePage;
    }

    public boolean isRemoveOldLibs() {
        return this.removeOldLibs;
    }

    public void setRemoveOldLibs(boolean removeOldLibs) {
        this.removeOldLibs = removeOldLibs;
    }

    public WindowsExeCreationTool getExeCreationTool() {
        return this.exeCreationTool;
    }

    public void setExeCreationTool(WindowsExeCreationTool exeCreationTool) {
        this.exeCreationTool = exeCreationTool;
    }

    public String toString() {
        return "WindowsConfig [icoFile=" + this.icoFile + ", headerType=" + (Object)((Object)this.headerType) + ", companyName=" + this.companyName + ", copyright=" + this.copyright + ", fileDescription=" + this.fileDescription + ", fileVersion=" + this.fileVersion + ", internalName=" + this.internalName + ", language=" + this.language + ", originalFilename=" + this.originalFilename + ", productName=" + this.productName + ", productVersion=" + this.productVersion + ", trademarks=" + this.trademarks + ", txtFileVersion=" + this.txtFileVersion + ", txtProductVersion=" + this.txtProductVersion + ", disableDirPage=" + this.disableDirPage + ", disableProgramGroupPage=" + this.disableProgramGroupPage + ", disableFinishedPage=" + this.disableFinishedPage + ", disableRunAfterInstall=" + this.disableRunAfterInstall + ", disableWelcomePage=" + this.disableWelcomePage + ", createDesktopIconTask=" + this.createDesktopIconTask + ", generateSetup=" + this.generateSetup + ", generateMsi=" + this.generateMsi + ", generateMsm=" + this.generateMsm + ", msiUpgradeCode=" + this.msiUpgradeCode + ", wrapJar=" + this.wrapJar + ", setupLanguages=" + this.setupLanguages + ", setupMode=" + (Object)((Object)this.setupMode) + ", signing=" + this.signing + ", registry=" + this.registry + ", removeOldLibs=" + this.removeOldLibs + ", exeCreationTool=" + (Object)((Object)this.exeCreationTool) + "]";
    }

    public void setDefaults(Packager packager) {
        this.setHeaderType(ObjectUtils.defaultIfNull(this.getHeaderType(), HeaderType.gui));
        this.setFileVersion((String)StringUtils.defaultIfBlank((CharSequence)this.getFileVersion(), (CharSequence)"1.0.0.0"));
        this.setTxtFileVersion((String)StringUtils.defaultIfBlank((CharSequence)this.getTxtFileVersion(), (CharSequence)("" + packager.getVersion())));
        this.setProductVersion((String)StringUtils.defaultIfBlank((CharSequence)this.getProductVersion(), (CharSequence)"1.0.0.0"));
        this.setTxtProductVersion((String)StringUtils.defaultIfBlank((CharSequence)this.getTxtProductVersion(), (CharSequence)("" + packager.getVersion())));
        this.setCompanyName((String)StringUtils.defaultIfBlank((CharSequence)this.getCompanyName(), (CharSequence)packager.getOrganizationName()));
        this.setCopyright((String)StringUtils.defaultIfBlank((CharSequence)this.getCopyright(), (CharSequence)packager.getOrganizationName()));
        this.setFileDescription((String)StringUtils.defaultIfBlank((CharSequence)this.getFileDescription(), (CharSequence)packager.getDescription()));
        this.setProductName((String)StringUtils.defaultIfBlank((CharSequence)this.getProductName(), (CharSequence)packager.getName()));
        this.setInternalName((String)StringUtils.defaultIfBlank((CharSequence)this.getInternalName(), (CharSequence)packager.getName()));
        this.setOriginalFilename((String)StringUtils.defaultIfBlank((CharSequence)this.getOriginalFilename(), (CharSequence)(packager.getName() + ".exe")));
        this.setMsiUpgradeCode((String)StringUtils.defaultIfBlank((CharSequence)this.getMsiUpgradeCode(), (CharSequence)UUID.randomUUID().toString()));
    }
}

