/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.AbstractCreateWindowsExe;
import io.github.fvarrui.javapackager.packagers.WindowsPackager;
import io.github.fvarrui.javapackager.utils.CommandUtils;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.JarUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;

public class CreateWindowsExeWinRun4j
extends AbstractCreateWindowsExe {
    public CreateWindowsExeWinRun4j() {
        super("winrun4j");
    }

    @Override
    public boolean skip(WindowsPackager packager) {
        if (!packager.getPlatform().isCurrentPlatform()) {
            Logger.error(this.getArtifactName() + " cannot be generated with WinRun4J due to the target platform (" + (Object)((Object)packager.getPlatform()) + ") is different from the execution platform (" + (Object)((Object)Platform.getCurrentPlatform()) + ")!");
            return true;
        }
        return false;
    }

    @Override
    protected File doApply(WindowsPackager packager) throws Exception {
        String name = packager.getName();
        File executable = packager.getExecutable();
        File jarFile = packager.getJarFile();
        File manifestFile = packager.getManifestFile();
        File iconFile = packager.getIconFile();
        File libsFolder = packager.getLibsFolder();
        File appFolder = packager.getAppFolder();
        String mainClass = packager.getMainClass();
        this.createAssets(packager);
        FileUtils.copyFileToFile(manifestFile, this.getGenericManifest());
        FileUtils.copyFileToFile(iconFile, this.getGenericIcon());
        FileUtils.copyResourceToFile("/windows/WinRun4J64.exe", this.getGenericExe());
        File rcedit = new File(this.getOutputFolder(), "rcedit.exe");
        FileUtils.copyResourceToFile("/windows/rcedit-x64.exe", rcedit);
        File genericIni = new File(this.getOutputFolder(), "app.ini");
        VelocityUtils.render("windows/ini.vtl", genericIni, packager);
        Logger.info("INI file generated in " + genericIni.getAbsolutePath() + "!");
        CommandUtils.execute(rcedit.getAbsolutePath(), this.getGenericExe(), "--set-icon", this.getGenericIcon());
        CommandUtils.execute(rcedit.getAbsolutePath(), this.getGenericExe(), "--application-manifest", this.getGenericManifest());
        if (libsFolder == null) {
            libsFolder = FileUtils.mkdir(appFolder, "libs");
        }
        FileUtils.copyFileToFolder(jarFile, libsFolder);
        File winrun4jJar = new File(libsFolder, "winrun4j-launcher-0.0.1.jar");
        FileUtils.copyResourceToFile("/windows/winrun4j-launcher-0.0.1.jar", winrun4jJar);
        File propertiesFile = new File(this.getOutputFolder(), "winrun4j.properties");
        Properties properties = new Properties();
        properties.setProperty("main.class", mainClass);
        properties.store(new FileOutputStream(propertiesFile), "WinRun4J Helper Launcher Properties");
        JarUtils.addFileToJar(winrun4jJar, propertiesFile);
        File iniFile = new File(appFolder, name + ".ini");
        FileUtils.copyFileToFile(genericIni, iniFile);
        this.sign(this.getGenericExe(), packager);
        FileUtils.copyFileToFile(this.getGenericExe(), executable);
        return this.createBootstrapScript(packager);
    }
}

